/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.resultset;

import eu.dnetlib.enabling.resultset.ResultSet;
import eu.dnetlib.enabling.resultset.ResultSetAware;
import eu.dnetlib.enabling.resultset.ResultSetListener;
import eu.dnetlib.enabling.resultset.rmi.ResultSetException;
import eu.dnetlib.enabling.resultset.rmi.ResultSetService;
import eu.dnetlib.enabling.tools.ServiceResolver;
import eu.dnetlib.miscutils.collections.MappedCollection;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import java.util.List;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.springframework.beans.factory.annotation.Required;

public class MappedResultSet
implements ResultSetListener,
ResultSetAware {
    private ResultSetService resultSetService;
    private String rsId;
    private UnaryFunction<String, String> mapper;
    private ServiceResolver serviceResolver;
    private ResultSet resultSet;

    public MappedResultSet(W3CEndpointReference epr, UnaryFunction<String, String> mapper, ServiceResolver serviceResolver) {
        this.resultSetService = (ResultSetService)serviceResolver.getService(ResultSetService.class, epr);
        this.rsId = serviceResolver.getResourceIdentifier(epr);
        this.mapper = mapper;
        this.serviceResolver = serviceResolver;
    }

    @Override
    public List<String> getResult(int fromPosition, int toPosition) {
        return MappedCollection.listMap(this.getResultFromSource(fromPosition, toPosition), this.mapper);
    }

    protected List<String> getResultFromSource(int fromPosition, int toPosition) {
        try {
            List res = this.resultSetService.getResult(this.rsId, fromPosition, toPosition, "waiting");
            this.checkStatus();
            return res;
        }
        catch (ResultSetException e) {
            throw new IllegalStateException(e);
        }
    }

    private void checkStatus() throws ResultSetException {
        if (this.getResultSet().isOpen() && this.resultSetService.getRSStatus(this.rsId).equals("closed")) {
            this.getResultSet().close();
        }
    }

    @Override
    public int getSize() {
        try {
            int numberOfElements = this.resultSetService.getNumberOfElements(this.rsId);
            this.checkStatus();
            return numberOfElements;
        }
        catch (ResultSetException e) {
            throw new IllegalStateException(e);
        }
    }

    public ResultSetService getResultSetService() {
        return this.resultSetService;
    }

    public void setResultSetService(ResultSetService resultSetService) {
        this.resultSetService = resultSetService;
    }

    public UnaryFunction<String, String> getMapper() {
        return this.mapper;
    }

    public void setMapper(UnaryFunction<String, String> mapper) {
        this.mapper = mapper;
    }

    public ServiceResolver getServiceResolver() {
        return this.serviceResolver;
    }

    @Required
    public void setServiceResolver(ServiceResolver serviceResolver) {
        this.serviceResolver = serviceResolver;
    }

    @Override
    public void setResultSet(ResultSet resultSet) {
        this.resultSet = resultSet;
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public String getRsId() {
        return this.rsId;
    }

    public void setRsId(String rsId) {
        this.rsId = rsId;
    }
}

