/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.resultset;

import java.util.Iterator;
import java.util.LinkedList;

public class FetchList<T>
extends LinkedList<T> {
    private static final long serialVersionUID = 7135272008563693321L;
    private int fetchSize;
    private int consumedElements = 0;
    private Iterator<T> iter;

    public FetchList(Iterator<T> iter, int fetchSize) {
        this.fetchSize = fetchSize;
        this.iter = iter;
    }

    public void fill() {
        for (int i = 0; i < this.fetchSize && this.iter.hasNext(); ++i) {
            this.add(this.iter.next());
        }
    }

    @Override
    public T poll() {
        if (this.isEmpty()) {
            this.fill();
        }
        if (this.size() > 0) {
            ++this.consumedElements;
            return (T)super.poll();
        }
        return null;
    }

    public int getConsumedElements() {
        return this.consumedElements;
    }

    public int getTotalElements() {
        return this.consumedElements + this.size();
    }

    @Override
    public int size() {
        if (this.isEmpty() && this.iter.hasNext()) {
            this.fill();
        }
        return super.size();
    }

    @Override
    public boolean isEmpty() {
        return super.size() == 0;
    }
}

