/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.resultset;

import eu.dnetlib.enabling.resultset.ResultSet;
import eu.dnetlib.enabling.resultset.ResultSetServiceImpl;
import eu.dnetlib.enabling.tools.UniqueIdentifierGenerator;
import eu.dnetlib.enabling.tools.UniqueIdentifierGeneratorImpl;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.PostConstruct;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class ResultSetEPRPool {
    private static final Log log = LogFactory.getLog(ResultSetEPRPool.class);
    private ResultSetServiceImpl resultSetService;
    private int capacity = 1000;
    private int fillerThreads = 10;
    private final BlockingQueue<PreparedResultSet> pool = new LinkedBlockingQueue<PreparedResultSet>(this.capacity);
    private UniqueIdentifierGenerator idGenerator = new UniqueIdentifierGeneratorImpl("rs-");

    @PostConstruct
    public void init() {
        log.info((Object)"-------<<<<<<<<<<<<<<<<<<<<<<<<<>>>>>>>>>>>>>>>>>>>> Starting fill threads");
        for (int i = 0; i < this.fillerThreads; ++i) {
            this.startFillter();
        }
    }

    protected void startFillter() {
        Thread filler = new Thread(new PoolFiller());
        filler.setDaemon(true);
        filler.start();
    }

    public W3CEndpointReference registerResultSet(ResultSet resultSet) {
        PreparedResultSet prepared = this.nextPreparedResultSet();
        if (prepared == null) {
            log.info((Object)"EPR cache is empty, creating EPR in caller thread");
            return this.getResultSetService().getEprBuilder().getEndpointReference((Object)this.getResultSetService().getEndpoint(), this.idGenerator.generateIdentifier());
        }
        this.getResultSetService().getResultsetRegistry().addResultSet(resultSet, prepared.getRsId());
        return prepared.getEpr();
    }

    private PreparedResultSet nextPreparedResultSet() {
        log.info((Object)">>>> fetching a prepared resultset from the pool");
        return (PreparedResultSet)this.pool.poll();
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public UniqueIdentifierGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public void setIdGenerator(UniqueIdentifierGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    public ResultSetServiceImpl getResultSetService() {
        return this.resultSetService;
    }

    @Required
    public void setResultSetService(ResultSetServiceImpl resultSetService) {
        this.resultSetService = resultSetService;
    }

    class PoolFiller
    implements Runnable {
        PoolFiller() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        PreparedResultSet resultSet = this.prepareResultSet();
                        ResultSetEPRPool.this.pool.put(resultSet);
                    }
                }
                catch (InterruptedException e) {
                    log.debug((Object)"cannot add resultset to pool", (Throwable)e);
                    continue;
                }
                break;
            }
        }

        private PreparedResultSet prepareResultSet() {
            String rsId = ResultSetEPRPool.this.idGenerator.generateIdentifier();
            return new PreparedResultSet(rsId, this.createEPR(rsId));
        }

        private W3CEndpointReference createEPR(String rsId) {
            return ResultSetEPRPool.this.getResultSetService().getEprBuilder().getEndpointReference((Object)ResultSetEPRPool.this.getResultSetService().getEndpoint(), rsId);
        }
    }

    static class PreparedResultSet {
        private String rsId;
        private W3CEndpointReference epr;

        public PreparedResultSet(String rsId, W3CEndpointReference epr) {
            this.rsId = rsId;
            this.epr = epr;
        }

        public String getRsId() {
            return this.rsId;
        }

        public void setRsId(String rsId) {
            this.rsId = rsId;
        }

        public W3CEndpointReference getEpr() {
            return this.epr;
        }

        public void setEpr(W3CEndpointReference epr) {
            this.epr = epr;
        }
    }
}

