/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.resultset;

import eu.dnetlib.enabling.resultset.ResultSet;
import eu.dnetlib.enabling.resultset.ResultSetAware;
import eu.dnetlib.enabling.resultset.ResultSetListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StreamingResultSetListener
implements ResultSetListener,
ResultSetAware {
    private static final Log log = LogFactory.getLog(StreamingResultSetListener.class);
    private ResultSet resultSet;
    private Iterable<String> iterable;
    private Iterator<String> items;
    private int size;
    private int lastFrom = 0;
    private int lastTo = 0;
    private List<String> lastChunk;

    public StreamingResultSetListener(Iterable<String> items, int size) {
        this(items.iterator(), size);
        this.iterable = items;
    }

    public StreamingResultSetListener(Iterator<String> items, int size) {
        this.items = items;
        this.size = size;
    }

    protected void reset() {
        this.lastFrom = 0;
        this.items = this.iterable.iterator();
    }

    @Override
    public List<String> getResult(int from, int to) {
        log.debug((Object)("STREAM: getResult(" + from + ", " + to + ")"));
        if (from == this.lastFrom && to == this.lastTo) {
            return this.lastChunk;
        }
        if (from != this.lastTo + 1) {
            if (from == 1 && this.iterable != null) {
                this.reset();
            } else {
                throw new IllegalArgumentException("this resultset is not random access, you can only retry last chunk only, asked from " + from + " to " + to + " but lastTo = " + this.lastTo + ". Size = " + this.size);
            }
        }
        ArrayList<String> chunk = new ArrayList<String>();
        for (int i = from; i <= to; ++i) {
            chunk.add(this.items.next());
        }
        if (this.resultSet != null && !this.items.hasNext()) {
            this.resultSet.close();
        }
        this.lastFrom = from;
        this.lastTo = to;
        this.lastChunk = chunk;
        return chunk;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public Iterator<String> getItems() {
        return this.items;
    }

    public void setItems(Iterator<String> items) {
        this.items = items;
    }

    public int getLastFrom() {
        return this.lastFrom;
    }

    public void setLastFrom(int lastFrom) {
        this.lastFrom = lastFrom;
    }

    public int getLastTo() {
        return this.lastTo;
    }

    public void setLastTo(int lastTo) {
        this.lastTo = lastTo;
    }

    public List<String> getLastChunk() {
        return this.lastChunk;
    }

    public void setLastChunk(List<String> lastChunk) {
        this.lastChunk = lastChunk;
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    @Override
    public void setResultSet(ResultSet resultSet) {
        this.resultSet = resultSet;
    }
}

