package eu.dnetlib.dlms.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;

import javax.sql.DataSource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.springframework.beans.factory.annotation.Required;

import eu.dnetlib.dlms.rmi.DLMSConnectionService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.enabling.tools.ServiceResolver;

public class WSRemoteDataSource implements DataSource {

	private ServiceLocator<DLMSConnectionService> connectionServiceLocator;
	private ServiceResolver serviceResolver;

	public Connection getConnection() throws SQLException {
		final W3CEndpointReference epr = connectionServiceLocator.getService().createConnection();
		final String connectionId = serviceResolver.getResourceIdentifier(epr);
		final DLMSConnectionService service = serviceResolver.getService(DLMSConnectionService.class, epr);
		
		return new WSRemoteConnection(serviceResolver, service, connectionId);
	}

	public Connection getConnection(final String arg0, final String arg1) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	public PrintWriter getLogWriter() throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	public int getLoginTimeout() throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}

	public void setLogWriter(final PrintWriter arg0) throws SQLException {
		// TODO Auto-generated method stub

	}

	public void setLoginTimeout(final int arg0) throws SQLException {
		// TODO Auto-generated method stub

	}

	public boolean isWrapperFor(final Class<?> arg0) throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	public <T> T unwrap(final Class<T> arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	public ServiceLocator<DLMSConnectionService> getConnectionServiceLocator() {
		return connectionServiceLocator;
	}

	@Required
	public void setConnectionServiceLocator(ServiceLocator<DLMSConnectionService> connectionServiceLocator) {
		this.connectionServiceLocator = connectionServiceLocator;
	}

	public ServiceResolver getServiceResolver() {
		return serviceResolver;
	}

	@Required
	public void setServiceResolver(ServiceResolver serviceResolver) {
		this.serviceResolver = serviceResolver;
	}

}
