package eu.dnetlib.dlms.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

import javax.xml.bind.JAXBException;

import eu.dnetlib.dlms.jdbc.serialization.CollectionDeserializer;
import eu.dnetlib.dlms.jdbc.serialization.ItemType;
import eu.dnetlib.dlms.jdbc.serialization.ItemWrapper;
import eu.dnetlib.dlms.jdbc.serialization.RSMetadataWrapper;
import eu.dnetlib.enabling.resultset.rmi.ResultSetException;
import eu.dnetlib.enabling.resultset.rmi.ResultSetService;
import eu.dnetlib.miscutils.jaxb.JaxbFactory;

public class WSRemoteResultSet implements ResultSet {

	private final WSRemoteStatement statement;
	private final ResultSetService resultSet;
	private final String rsId;

	private int position = 1;
	/** Serialization of the current row (that at position position-1). Null if no rows have been read so far. */
	private String currentValue;
	/** Metadata for this ResultSet. */
	private WSRemoteMetaData metaData;

	private CollectionDeserializer collDeserializer = new CollectionDeserializer();

	/**
	 * Sets this.metaData to a new WSRemoteMetaData having metaDataWrapper as content.
	 * 
	 * @param metaDataWrapper
	 *            RSMetadataWrapper metadata content
	 */
	public void setMetaData(final RSMetadataWrapper metaDataWrapper) {
		this.metaData = new WSRemoteMetaData(metaDataWrapper);
	}

	public WSRemoteResultSet(final WSRemoteStatement statement, final ResultSetService resultSet, final String rsId) {
		super();
		this.statement = statement;
		this.resultSet = resultSet;
		this.rsId = rsId;
	}

	public String getString(final int columnIndex) throws SQLException {
		final ItemWrapper item = this.unwrap(this.currentValue);
		if (item.getTypes().get(columnIndex - 1) == ItemType.STRING)
			return item.getValues().get(columnIndex - 1);
		else
			this.wrongType(ItemType.STRING);
		return null;
	}

	public int getInt(final int columnIndex) throws SQLException {
		final ItemWrapper item = this.unwrap(this.currentValue);
		if (item.getTypes().get(columnIndex - 1) == ItemType.INT)
			return Integer.parseInt(item.getValues().get(columnIndex - 1));
		else
			this.wrongType(ItemType.INT);
		return 0;
	}

	public long getLong(final int columnIndex) throws SQLException {
		final ItemWrapper item = this.unwrap(this.currentValue);
		final ItemType it = item.getTypes().get(columnIndex - 1);
		if (it == ItemType.INT || it == ItemType.LONG)
			return Long.parseLong(item.getValues().get(columnIndex - 1));
		else
			this.wrongType(ItemType.LONG);
		return 0;
	}

	public boolean getBoolean(final int columnIndex) throws SQLException {
		final ItemWrapper item = this.unwrap(this.currentValue);
		if (item.getTypes().get(columnIndex - 1) == ItemType.BOOLEAN)
			return Boolean.parseBoolean(item.getValues().get(columnIndex - 1));
		else
			this.wrongType(ItemType.BOOLEAN);
		return false;
	}

	public Date getDate(final int columnIndex) throws SQLException {
		final ItemWrapper item = this.unwrap(this.currentValue);
		if (item.getTypes().get(columnIndex - 1) == ItemType.DATE)
			return Date.valueOf(item.getValues().get(columnIndex - 1));
		else
			this.wrongType(ItemType.DATE);
		return null;
	}

	public double getDouble(final int columnIndex) throws SQLException {
		final ItemWrapper item = this.unwrap(this.currentValue);
		if (item.getTypes().get(columnIndex - 1) == ItemType.DOUBLE)
			return Double.parseDouble(item.getValues().get(columnIndex - 1));
		else
			this.wrongType(ItemType.DOUBLE);
		return 0;
	}

	public URL getURL(final int columnIndex) throws SQLException {
		final ItemWrapper item = this.unwrap(this.currentValue);
		final ItemType it = item.getTypes().get(columnIndex - 1);
		if (it == ItemType.STRING || it == ItemType.URL)
			try {
				return new URL(item.getValues().get(columnIndex - 1));
			} catch (final MalformedURLException e) {
				throw new SQLException(e);
			}
		else
			this.wrongType(ItemType.URL);
		return null;
	}

	/**
	 *{@inheritDoc}.
	 * 
	 * @see java.sql.ResultSet#getObject(int)
	 */
	public Object getObject(final int columnIndex) throws SQLException {
		if (this.currentValue == null)
			return null;
		final ItemWrapper item = this.unwrap(this.currentValue);
		final String value = item.getValues().get(columnIndex - 1);
		if (value == null || value.trim().isEmpty())
			return null;
		else
			return this.deserialize(item.getValues().get(columnIndex - 1), item.getTypes().get(columnIndex - 1));
	}

	/**
	 * Deserializes the string in the right object according to the given type.
	 * 
	 * @param columnValue
	 *            String
	 * @param columnType
	 *            ItemType
	 * @return Object
	 */
	private Object deserialize(final String columnValue, final ItemType columnType) {
		switch (columnType) {
		case INFORMATION_OBJECT:
			return new InformationObjectReference(columnValue);
		case BOOLEAN:
			return Boolean.parseBoolean(columnValue);
		case DATE:
			return Date.valueOf(columnValue);
		case DOUBLE:
			return Double.parseDouble(columnValue);
		case STRING:
			return columnValue;
		case URL:
			try {
				return new URL(columnValue);
			} catch (final MalformedURLException e) {
				throw new RuntimeException("Malformed URL: " + columnValue, e);
			}
		case INT:
			return Integer.parseInt(columnValue);
		case LONG:
			return Long.parseLong(columnValue);
		case COLL:
			return this.collDeserializer.deserialize(columnValue);
		default:
			throw new RuntimeException("Cannot deserialize " + columnValue + " : unknown type " + columnType);
		}
	}

	public boolean next() throws SQLException {
		try {
			final List<String> res = this.resultSet.getResult(this.rsId, this.position, this.position, "waiting");
			if (res == null || res.isEmpty())
				return false;
			this.currentValue = res.get(0);

			System.out.println("currentValue set to " + this.currentValue);
			this.position++;

			return true;
		} catch (final ResultSetException e) {
			throw new SQLException("cannot fetch result", e);
		}
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see java.sql.ResultSet#getMetaData()
	 */
	public ResultSetMetaData getMetaData() throws SQLException {
		/*
		 * Se this.metaData == null --> devo ancora ottenerla perche' non si e' fatta ancora una next. Quindi faccio una
		 * resultSet.getResult(0,0) che mi da come risultato una lista di 1 stringa che mi aspetto essere la
		 * serializzazione di un WSRemoteMetaData Unwrappo la stringa e setto i metaData.
		 */
		if (this.metaData == null) {
			//setta metaData
			try {
				final List<String> res = this.resultSet.getResult(this.rsId, 0, 0, "waiting");
				if (res == null || res.isEmpty())
					throw new SQLException("cannot fetch resultset metadata: resultList from " + this.resultSet + " is null or empty");
				final String metadataSer = res.get(0);
				this.setMetaData(this.unwrapMetaData(metadataSer));
			} catch (final ResultSetException e) {
				throw new SQLException("cannot fetch resultset metadata", e);
			}
		}
		return this.metaData;
	}

	private void wrongType(final ItemType type) throws SQLException {
		throw new SQLException("Wrong type, expected: " + type);
	}

	private void unimplemented() throws SQLException {
		throw new SQLException("Currently unimplemented, stay tuned");
	}

	public ItemWrapper unwrap(final String item) {
		try {
			final JaxbFactory<ItemWrapper> factory = new JaxbFactory<ItemWrapper>(ItemWrapper.class);
			return factory.parse(item);
		} catch (final JAXBException e) {
			throw new IllegalStateException("cannot deserialize item wrapper", e);
		}
	}

	public RSMetadataWrapper unwrapMetaData(final String metadata) {
		try {
			final JaxbFactory<RSMetadataWrapper> factory = new JaxbFactory<RSMetadataWrapper>(RSMetadataWrapper.class);
			return factory.parse(metadata);
		} catch (final JAXBException e) {
			throw new IllegalStateException("cannot deserialize metadata wrapper", e);
		}
	}

	//	private List<String> deserializeCollString(final String str) {
	//		//I expect s is [el1, el2, etc]: remove the first and last char ([ and ]) and split it on ,
	//		final String valueNoBrackets = str.substring(1, str.length() - 1).trim();
	//		final List<String> res = new ArrayList<String>();
	//		final String[] els = valueNoBrackets.split(",");
	//		for (final String el : els)
	//			res.add(el.trim());
	//		return res;
	//	}

	//	private List<Map<String, Object>> deserializeCollD(final String str) {
	//		final String valueNoBrackets = str.substring(1, str.length() - 1).trim();
	//		final List<Map<String, Object>> res = new ArrayList<Map<String, Object>>();
	//		final String[] collEls = valueNoBrackets.split("},");
	//		System.out.println("collEls is: " + Arrays.toString(collEls));
	//		//in collEls I have: {l1=v1,l2=v2 {l1=v11,l2=v12 {l1=v13,l2=v23}
	//		for (String el : collEls) {
	//
	//			final Map<String, Object> elMap = new HashMap<String, Object>();
	//			el = el.replaceFirst("\\s?\\{\\s?", " ");
	//			el = el.replaceFirst("\\s?}\\s?", " ");
	//			System.out.println("El in collEls: " + el);
	//			//this is applied only at the last element if we do not have nested structures.
	//
	//			//el = l1=v1,l2=v2
	//			final String[] couples = el.split(",");
	//			for (final String c : couples) {
	//				final String[] coupleSplitted = c.split("\\s?=\\s?");
	//				//System.out.println("Couples should have length 2, is it? " + coupleSplitted.length);
	//				elMap.put(coupleSplitted[0], coupleSplitted[1]);
	//			}
	//			res.add(elMap);
	//		}
	//		return res;
	//	}

	public void setMetaData(final WSRemoteMetaData metaData) {
		this.metaData = metaData;
	}

	public boolean absolute(final int row) throws SQLException {
		this.unimplemented();
		return false;
	}

	public void afterLast() throws SQLException {
		this.unimplemented();
	}

	public void beforeFirst() throws SQLException {
		this.unimplemented();
	}

	public void cancelRowUpdates() throws SQLException {

		this.unimplemented();
	}

	public void clearWarnings() throws SQLException {

		this.unimplemented();
	}

	public void close() throws SQLException {

	}

	public void deleteRow() throws SQLException {

		this.unimplemented();
	}

	public int findColumn(final String columnLabel) throws SQLException {
		this.unimplemented();

		return 0;
	}

	public boolean first() throws SQLException {
		this.unimplemented();

		return false;
	}

	public Array getArray(final String columnLabel) throws SQLException {
		this.unimplemented();

		return null;
	}

	public InputStream getAsciiStream(final int columnIndex) throws SQLException {
		this.unimplemented();

		return null;
	}

	public InputStream getAsciiStream(final String columnLabel) throws SQLException {
		this.unimplemented();

		return null;
	}

	public BigDecimal getBigDecimal(final int columnIndex) throws SQLException {
		this.unimplemented();

		return null;
	}

	public BigDecimal getBigDecimal(final String columnLabel) throws SQLException {
		this.unimplemented();

		return null;
	}

	public BigDecimal getBigDecimal(final int columnIndex, final int scale) throws SQLException {
		this.unimplemented();

		return null;
	}

	public BigDecimal getBigDecimal(final String columnLabel, final int scale) throws SQLException {
		this.unimplemented();

		return null;
	}

	public InputStream getBinaryStream(final int columnIndex) throws SQLException {
		this.unimplemented();

		return null;
	}

	public InputStream getBinaryStream(final String columnLabel) throws SQLException {
		this.unimplemented();

		return null;
	}

	public Blob getBlob(final int columnIndex) throws SQLException {
		this.unimplemented();

		return null;
	}

	public Blob getBlob(final String columnLabel) throws SQLException {
		this.unimplemented();

		return null;
	}

	public boolean getBoolean(final String columnLabel) throws SQLException {
		this.unimplemented();

		return false;
	}

	public byte getByte(final int columnIndex) throws SQLException {
		this.unimplemented();

		return 0;
	}

	public byte getByte(final String columnLabel) throws SQLException {
		this.unimplemented();

		return 0;
	}

	public byte[] getBytes(final int columnIndex) throws SQLException {
		this.unimplemented();

		return null;
	}

	public byte[] getBytes(final String columnLabel) throws SQLException {
		this.unimplemented();

		return null;
	}

	public Reader getCharacterStream(final int columnIndex) throws SQLException {
		this.unimplemented();

		return null;
	}

	public Reader getCharacterStream(final String columnLabel) throws SQLException {
		this.unimplemented();

		return null;
	}

	public Clob getClob(final int columnIndex) throws SQLException {
		this.unimplemented();

		return null;
	}

	public Clob getClob(final String columnLabel) throws SQLException {
		this.unimplemented();

		return null;
	}

	public int getConcurrency() throws SQLException {
		this.unimplemented();

		return 0;
	}

	public String getCursorName() throws SQLException {
		this.unimplemented();

		return null;
	}

	public Date getDate(final String columnLabel) throws SQLException {
		this.unimplemented();

		return null;
	}

	public Date getDate(final int columnIndex, final Calendar cal) throws SQLException {
		this.unimplemented();

		return null;
	}

	public Date getDate(final String columnLabel, final Calendar cal) throws SQLException {
		this.unimplemented();

		return null;
	}

	public double getDouble(final String columnLabel) throws SQLException {
		this.unimplemented();

		return 0;
	}

	public int getFetchDirection() throws SQLException {
		this.unimplemented();

		return 0;
	}

	public int getFetchSize() throws SQLException {
		this.unimplemented();

		return 0;
	}

	public float getFloat(final int columnIndex) throws SQLException {
		this.unimplemented();

		return 0;
	}

	public float getFloat(final String columnLabel) throws SQLException {
		this.unimplemented();

		return 0;
	}

	public int getHoldability() throws SQLException {
		this.unimplemented();

		return 0;
	}

	public int getInt(final String columnLabel) throws SQLException {
		this.unimplemented();

		return 0;
	}

	public long getLong(final String columnLabel) throws SQLException {
		this.unimplemented();

		return 0;
	}

	public Reader getNCharacterStream(final int columnIndex) throws SQLException {
		this.unimplemented();

		return null;
	}

	public Reader getNCharacterStream(final String columnLabel) throws SQLException {
		this.unimplemented();

		return null;
	}

	public NClob getNClob(final int columnIndex) throws SQLException {
		this.unimplemented();

		return null;
	}

	public NClob getNClob(final String columnLabel) throws SQLException {
		this.unimplemented();

		return null;
	}

	public String getNString(final int columnIndex) throws SQLException {
		this.unimplemented();

		return null;
	}

	public String getNString(final String columnLabel) throws SQLException {
		this.unimplemented();

		return null;
	}

	public Object getObject(final String columnLabel) throws SQLException {
		this.unimplemented();

		return null;
	}

	public Object getObject(final int columnIndex, final Map<String, Class<?>> map) throws SQLException {
		this.unimplemented();

		return null;
	}

	public Object getObject(final String columnLabel, final Map<String, Class<?>> map) throws SQLException {
		this.unimplemented();

		return null;
	}

	public Ref getRef(final int columnIndex) throws SQLException {
		this.unimplemented();

		return null;
	}

	public Ref getRef(final String columnLabel) throws SQLException {
		this.unimplemented();

		return null;
	}

	public int getRow() throws SQLException {
		return this.position - 1;
	}

	public RowId getRowId(final int columnIndex) throws SQLException {
		this.unimplemented();

		return null;
	}

	public RowId getRowId(final String columnLabel) throws SQLException {
		this.unimplemented();

		return null;
	}

	public SQLXML getSQLXML(final int columnIndex) throws SQLException {
		this.unimplemented();

		return null;
	}

	public SQLXML getSQLXML(final String columnLabel) throws SQLException {
		this.unimplemented();

		return null;
	}

	public short getShort(final int columnIndex) throws SQLException {
		this.unimplemented();

		return 0;
	}

	public short getShort(final String columnLabel) throws SQLException {
		this.unimplemented();

		return 0;
	}

	public Statement getStatement() throws SQLException {
		return this.statement;
	}

	public String getString(final String columnLabel) throws SQLException {
		this.unimplemented();

		return null;
	}

	public Time getTime(final int columnIndex) throws SQLException {
		this.unimplemented();

		return null;
	}

	public Time getTime(final String columnLabel) throws SQLException {
		this.unimplemented();

		return null;
	}

	public Time getTime(final int columnIndex, final Calendar cal) throws SQLException {
		this.unimplemented();

		return null;
	}

	public Time getTime(final String columnLabel, final Calendar cal) throws SQLException {
		this.unimplemented();

		return null;
	}

	public Timestamp getTimestamp(final int columnIndex) throws SQLException {
		this.unimplemented();

		return null;
	}

	public Timestamp getTimestamp(final String columnLabel) throws SQLException {
		this.unimplemented();

		return null;
	}

	public Timestamp getTimestamp(final int columnIndex, final Calendar cal) throws SQLException {
		this.unimplemented();

		return null;
	}

	public Timestamp getTimestamp(final String columnLabel, final Calendar cal) throws SQLException {
		this.unimplemented();

		return null;
	}

	public int getType() throws SQLException {
		this.unimplemented();

		return 0;
	}

	public URL getURL(final String columnLabel) throws SQLException {
		this.unimplemented();

		return null;
	}

	public InputStream getUnicodeStream(final int columnIndex) throws SQLException {
		this.unimplemented();

		return null;
	}

	public InputStream getUnicodeStream(final String columnLabel) throws SQLException {
		this.unimplemented();

		return null;
	}

	public SQLWarning getWarnings() throws SQLException {
		this.unimplemented();

		return null;
	}

	public void insertRow() throws SQLException {
		this.unimplemented();

	}

	public boolean isAfterLast() throws SQLException {
		this.unimplemented();

		return false;
	}

	public boolean isBeforeFirst() throws SQLException {
		this.unimplemented();

		return false;
	}

	public boolean isClosed() throws SQLException {

		return false;
	}

	public boolean isFirst() throws SQLException {
		this.unimplemented();

		return false;
	}

	public boolean isLast() throws SQLException {
		this.unimplemented();

		return false;
	}

	public boolean last() throws SQLException {
		this.unimplemented();

		return false;
	}

	public void moveToCurrentRow() throws SQLException {
		this.unimplemented();

	}

	public void moveToInsertRow() throws SQLException {
		this.unimplemented();

	}

	public boolean previous() throws SQLException {
		this.unimplemented();

		return false;
	}

	public void refreshRow() throws SQLException {
		this.unimplemented();

	}

	public boolean relative(final int rows) throws SQLException {
		this.unimplemented();

		return false;
	}

	public boolean rowDeleted() throws SQLException {
		this.unimplemented();

		return false;
	}

	public boolean rowInserted() throws SQLException {

		return false;
	}

	public boolean rowUpdated() throws SQLException {
		this.unimplemented();

		return false;
	}

	public void setFetchDirection(final int direction) throws SQLException {
		this.unimplemented();

	}

	public void setFetchSize(final int rows) throws SQLException {

	}

	public void updateArray(final int columnIndex, final Array x) throws SQLException {
		this.unimplemented();

	}

	public void updateArray(final String columnLabel, final Array x) throws SQLException {
		this.unimplemented();

	}

	public void updateAsciiStream(final int columnIndex, final InputStream x) throws SQLException {
		this.unimplemented();

	}

	public void updateAsciiStream(final String columnLabel, final InputStream x) throws SQLException {
		this.unimplemented();

	}

	public void updateAsciiStream(final int columnIndex, final InputStream x, final int length) throws SQLException {
		this.unimplemented();

	}

	public void updateAsciiStream(final String columnLabel, final InputStream x, final int length) throws SQLException {
		this.unimplemented();

	}

	public void updateAsciiStream(final int columnIndex, final InputStream x, final long length) throws SQLException {
		this.unimplemented();

	}

	public void updateAsciiStream(final String columnLabel, final InputStream x, final long length) throws SQLException {
		this.unimplemented();

	}

	public void updateBigDecimal(final int columnIndex, final BigDecimal x) throws SQLException {
		this.unimplemented();

	}

	public void updateBigDecimal(final String columnLabel, final BigDecimal x) throws SQLException {
		this.unimplemented();

	}

	public void updateBinaryStream(final int columnIndex, final InputStream x) throws SQLException {
		this.unimplemented();

	}

	public void updateBinaryStream(final String columnLabel, final InputStream x) throws SQLException {
		this.unimplemented();

	}

	public void updateBinaryStream(final int columnIndex, final InputStream x, final int length) throws SQLException {
		this.unimplemented();

	}

	public void updateBinaryStream(final String columnLabel, final InputStream x, final int length) throws SQLException {
		this.unimplemented();

	}

	public void updateBinaryStream(final int columnIndex, final InputStream x, final long length) throws SQLException {
		this.unimplemented();

	}

	public void updateBinaryStream(final String columnLabel, final InputStream x, final long length) throws SQLException {
		this.unimplemented();

	}

	public void updateBlob(final int columnIndex, final Blob x) throws SQLException {
		this.unimplemented();

	}

	public void updateBlob(final String columnLabel, final Blob x) throws SQLException {
		this.unimplemented();

	}

	public void updateBlob(final int columnIndex, final InputStream inputStream) throws SQLException {
		this.unimplemented();

	}

	public void updateBlob(final String columnLabel, final InputStream inputStream) throws SQLException {
		this.unimplemented();

	}

	public void updateBlob(final int columnIndex, final InputStream inputStream, final long length) throws SQLException {
		this.unimplemented();

	}

	public void updateBlob(final String columnLabel, final InputStream inputStream, final long length) throws SQLException {
		this.unimplemented();

	}

	public void updateBoolean(final int columnIndex, final boolean x) throws SQLException {
		this.unimplemented();

	}

	public void updateBoolean(final String columnLabel, final boolean x) throws SQLException {
		this.unimplemented();

	}

	public void updateByte(final int columnIndex, final byte x) throws SQLException {
		this.unimplemented();

	}

	public void updateByte(final String columnLabel, final byte x) throws SQLException {
		this.unimplemented();

	}

	public void updateBytes(final int columnIndex, final byte[] x) throws SQLException {
		this.unimplemented();

	}

	public void updateBytes(final String columnLabel, final byte[] x) throws SQLException {
		this.unimplemented();

	}

	public void updateCharacterStream(final int columnIndex, final Reader x) throws SQLException {
		this.unimplemented();

	}

	public void updateCharacterStream(final String columnLabel, final Reader reader) throws SQLException {
		this.unimplemented();

	}

	public void updateCharacterStream(final int columnIndex, final Reader x, final int length) throws SQLException {
		this.unimplemented();

	}

	public void updateCharacterStream(final String columnLabel, final Reader reader, final int length) throws SQLException {

		this.unimplemented();
	}

	public void updateCharacterStream(final int columnIndex, final Reader x, final long length) throws SQLException {

		this.unimplemented();
	}

	public void updateCharacterStream(final String columnLabel, final Reader reader, final long length) throws SQLException {

		this.unimplemented();
	}

	public void updateClob(final int columnIndex, final Clob x) throws SQLException {

		this.unimplemented();
	}

	public void updateClob(final String columnLabel, final Clob x) throws SQLException {

		this.unimplemented();
	}

	public void updateClob(final int columnIndex, final Reader reader) throws SQLException {

		this.unimplemented();
	}

	public void updateClob(final String columnLabel, final Reader reader) throws SQLException {

		this.unimplemented();
	}

	public void updateClob(final int columnIndex, final Reader reader, final long length) throws SQLException {

		this.unimplemented();
	}

	public void updateClob(final String columnLabel, final Reader reader, final long length) throws SQLException {

		this.unimplemented();
	}

	public void updateDate(final int columnIndex, final Date x) throws SQLException {

		this.unimplemented();
	}

	public void updateDate(final String columnLabel, final Date x) throws SQLException {

		this.unimplemented();
	}

	public void updateDouble(final int columnIndex, final double x) throws SQLException {

		this.unimplemented();
	}

	public void updateDouble(final String columnLabel, final double x) throws SQLException {

		this.unimplemented();
	}

	public void updateFloat(final int columnIndex, final float x) throws SQLException {

		this.unimplemented();
	}

	public void updateFloat(final String columnLabel, final float x) throws SQLException {

		this.unimplemented();
	}

	public void updateInt(final int columnIndex, final int x) throws SQLException {

		this.unimplemented();
	}

	public void updateInt(final String columnLabel, final int x) throws SQLException {

		this.unimplemented();
	}

	public void updateLong(final int columnIndex, final long x) throws SQLException {

		this.unimplemented();
	}

	public void updateLong(final String columnLabel, final long x) throws SQLException {

		this.unimplemented();
	}

	public void updateNCharacterStream(final int columnIndex, final Reader x) throws SQLException {

		this.unimplemented();
	}

	public void updateNCharacterStream(final String columnLabel, final Reader reader) throws SQLException {

		this.unimplemented();
	}

	public void updateNCharacterStream(final int columnIndex, final Reader x, final long length) throws SQLException {

		this.unimplemented();
	}

	public void updateNCharacterStream(final String columnLabel, final Reader reader, final long length) throws SQLException {

		this.unimplemented();
	}

	public void updateNClob(final int columnIndex, final NClob nClob) throws SQLException {

		this.unimplemented();
	}

	public void updateNClob(final String columnLabel, final NClob nClob) throws SQLException {

		this.unimplemented();
	}

	public void updateNClob(final int columnIndex, final Reader reader) throws SQLException {

		this.unimplemented();
	}

	public void updateNClob(final String columnLabel, final Reader reader) throws SQLException {

		this.unimplemented();
	}

	public void updateNClob(final int columnIndex, final Reader reader, final long length) throws SQLException {

		this.unimplemented();
	}

	public void updateNClob(final String columnLabel, final Reader reader, final long length) throws SQLException {

		this.unimplemented();
	}

	public void updateNString(final int columnIndex, final String nString) throws SQLException {

		this.unimplemented();
	}

	public void updateNString(final String columnLabel, final String nString) throws SQLException {

		this.unimplemented();
	}

	public void updateNull(final int columnIndex) throws SQLException {

		this.unimplemented();
	}

	public void updateNull(final String columnLabel) throws SQLException {

		this.unimplemented();
	}

	public void updateObject(final int columnIndex, final Object x) throws SQLException {

		this.unimplemented();
	}

	public void updateObject(final String columnLabel, final Object x) throws SQLException {

		this.unimplemented();
	}

	public void updateObject(final int columnIndex, final Object x, final int scaleOrLength) throws SQLException {

		this.unimplemented();
	}

	public void updateObject(final String columnLabel, final Object x, final int scaleOrLength) throws SQLException {

		this.unimplemented();
	}

	public void updateRef(final int columnIndex, final Ref x) throws SQLException {

		this.unimplemented();
	}

	public void updateRef(final String columnLabel, final Ref x) throws SQLException {

		this.unimplemented();
	}

	public void updateRow() throws SQLException {

		this.unimplemented();
	}

	public void updateRowId(final int columnIndex, final RowId x) throws SQLException {

		this.unimplemented();
	}

	public void updateRowId(final String columnLabel, final RowId x) throws SQLException {

		this.unimplemented();
	}

	public void updateSQLXML(final int columnIndex, final SQLXML xmlObject) throws SQLException {

		this.unimplemented();
	}

	public void updateSQLXML(final String columnLabel, final SQLXML xmlObject) throws SQLException {

		this.unimplemented();
	}

	public void updateShort(final int columnIndex, final short x) throws SQLException {

		this.unimplemented();
	}

	public void updateShort(final String columnLabel, final short x) throws SQLException {

		this.unimplemented();
	}

	public void updateString(final int columnIndex, final String x) throws SQLException {

		this.unimplemented();
	}

	public void updateString(final String columnLabel, final String x) throws SQLException {

		this.unimplemented();
	}

	public void updateTime(final int columnIndex, final Time x) throws SQLException {

		this.unimplemented();
	}

	public void updateTime(final String columnLabel, final Time x) throws SQLException {

		this.unimplemented();
	}

	public void updateTimestamp(final int columnIndex, final Timestamp x) throws SQLException {

		this.unimplemented();
	}

	public void updateTimestamp(final String columnLabel, final Timestamp x) throws SQLException {
		this.unimplemented();
	}

	public boolean wasNull() throws SQLException {
		this.unimplemented();
		return false;
	}

	public boolean isWrapperFor(final Class<?> arg0) throws SQLException {
		return false;
	}

	public <T> T unwrap(final Class<T> arg0) throws SQLException {
		this.unimplemented();
		return null;
	}

	public Array getArray(final int columnIndex) throws SQLException {
		this.unimplemented();
		return null;
	}

	public int getPosition() {
		return this.position;
	}

	public void setPosition(final int position) {
		this.position = position;
	}

	public String getCurrentValue() {
		return this.currentValue;
	}

	public void setCurrentValue(final String currentValue) {
		this.currentValue = currentValue;
	}

}
