package eu.dnetlib.dlms.jdbc.serialization;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlRootElement;

/**
 * @author lexis
 * 
 */
@XmlRootElement(name = "rsmetadata", namespace = "http://dnetlib.eu/rsmetadatawrapper")
public class RSMetadataWrapper {

	private int columnCount;
	private List<String> columnNames;
	private List<Integer> columnTypeCodes;

	public int getColumnCount() {
		return this.columnCount;
	}

	public void setColumnCount(final int columnCount) {
		this.columnCount = columnCount;
	}

	public List<String> getColumnNames() {
		return this.columnNames;
	}

	public void setColumnNames(final List<String> columnNames) {
		this.columnNames = columnNames;
	}

	public List<Integer> getColumnTypeCodes() {
		return this.columnTypeCodes;
	}

	public void setColumnTypeCodes(final List<Integer> columnTypeCodes) {
		this.columnTypeCodes = columnTypeCodes;
	}

	/**
	 * Constructor.
	 * 
	 * @param columnCount
	 *            int, number of columns
	 * @param columnNames
	 *            String list, names of the column
	 * @param columnTypeCodes
	 *            int List, types of the columns as integers (see DorotyObjectEnum)
	 */
	public RSMetadataWrapper(final int columnCount, final List<String> columnNames, final List<Integer> columnTypeCodes) {
		super();
		this.columnCount = columnCount;
		this.columnNames = columnNames;
		this.columnTypeCodes = columnTypeCodes;
	}

	/**
	 * Constructor. Initializes lists.
	 */
	public RSMetadataWrapper() {
		super();
		this.columnCount = 0;
		this.columnNames = new ArrayList<String>();
		this.columnTypeCodes = new ArrayList<Integer>();
	}

}
