/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dlms.jdbc;

import eu.dnetlib.dlms.jdbc.InformationObject;
import eu.dnetlib.dlms.jdbc.serialization.RSMetadataWrapper;
import java.net.URL;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collection;

public class WSRemoteMetaData
implements ResultSetMetaData {
    private RSMetadataWrapper metaData;

    @Override
    public int getColumnCount() throws SQLException {
        return this.metaData.getColumnCount();
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.getColumnName(column);
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.metaData.getColumnNames().get(column - 1);
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return this.metaData.getColumnTypeCodes().get(column - 1);
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return this.getClassName(this.metaData.getColumnTypeCodes().get(column - 1));
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return this.getTypeName(this.metaData.getColumnTypeCodes().get(column - 1));
    }

    public void setMetaData(RSMetadataWrapper metaData) {
        this.metaData = metaData;
    }

    private String getClassName(int typeCode) {
        switch (typeCode) {
            case 0: 
            case 1: {
                return String.class.getCanonicalName();
            }
            case 2: 
            case 3: {
                return Integer.class.getCanonicalName();
            }
            case 4: 
            case 5: {
                return Date.class.getCanonicalName();
            }
            case 6: 
            case 7: {
                return Boolean.class.getCanonicalName();
            }
            case 8: {
                return URL.class.getCanonicalName();
            }
            case 9: {
                return Long.class.getCanonicalName();
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return InformationObject.class.getCanonicalName();
            }
            case 14: 
            case 15: {
                return Double.class.getCanonicalName();
            }
            case 16: {
                return Collection.class.getCanonicalName();
            }
            case 17: {
                return InformationObject.class.getCanonicalName();
            }
        }
        return null;
    }

    private String getTypeName(int typeCode) {
        switch (typeCode) {
            case 0: 
            case 1: {
                return String.class.getCanonicalName();
            }
            case 2: 
            case 3: {
                return Integer.TYPE.getCanonicalName();
            }
            case 4: 
            case 5: {
                return Date.class.getCanonicalName();
            }
            case 6: 
            case 7: {
                return Boolean.TYPE.getCanonicalName();
            }
            case 8: {
                return URL.class.getCanonicalName();
            }
            case 9: {
                return Long.TYPE.getCanonicalName();
            }
            case 10: {
                return "Atom";
            }
            case 11: {
                return "Relation";
            }
            case 12: {
                return "Structure";
            }
            case 13: {
                return "LLDigitalObject";
            }
            case 14: 
            case 15: {
                return Double.TYPE.getCanonicalName();
            }
            case 16: {
                return "DescriptionValueCollection";
            }
            case 17: {
                return "Set";
            }
        }
        return null;
    }

    public RSMetadataWrapper getMetaData() {
        return this.metaData;
    }

    private void unimplemented() throws SQLException {
        throw new SQLException("Currently unimplemented, stay tuned");
    }

    public WSRemoteMetaData() {
    }

    public WSRemoteMetaData(RSMetadataWrapper metaData) {
        this.metaData = metaData;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        this.unimplemented();
        return null;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        this.unimplemented();
        return 0;
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        this.unimplemented();
        return 0;
    }

    @Override
    public int getScale(int column) throws SQLException {
        this.unimplemented();
        return 0;
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        this.unimplemented();
        return null;
    }

    @Override
    public String getTableName(int column) throws SQLException {
        this.unimplemented();
        return null;
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        this.unimplemented();
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        this.unimplemented();
        return false;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        this.unimplemented();
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        this.unimplemented();
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        this.unimplemented();
        return 0;
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        this.unimplemented();
        return false;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        this.unimplemented();
        return false;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        this.unimplemented();
        return false;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        this.unimplemented();
        return false;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        this.unimplemented();
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        this.unimplemented();
        return null;
    }
}

