/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dlms.jdbc;

import eu.dnetlib.dlms.jdbc.InformationObject;
import eu.dnetlib.dlms.jdbc.WSRemoteConnection;
import eu.dnetlib.dlms.jdbc.WSRemoteStatement;
import eu.dnetlib.dlms.rmi.ParameterDescription;
import eu.dnetlib.dlms.rmi.StatementDescription;
import eu.dnetlib.enabling.tools.ServiceResolver;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;

public class WSRemotePreparedStatement
extends WSRemoteStatement
implements PreparedStatement {
    private StatementDescription statementDescription = new StatementDescription();

    public WSRemotePreparedStatement(ServiceResolver serviceResolver, WSRemoteConnection connection, String source) {
        super(serviceResolver, connection);
        this.statementDescription.setSource(source);
    }

    @Override
    public boolean execute() throws SQLException {
        this.remoteExecute(this.statementDescription);
        return true;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.remoteExecute(this.statementDescription);
        return this.getResultSet();
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.remoteExecute(this.statementDescription);
        this.getResultSet().next();
        return 0;
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.setParameter(parameterIndex, new ParameterDescription("STRING", x));
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.setParameter(parameterIndex, new ParameterDescription("INT", Integer.toString(x)));
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.setParameter(parameterIndex, new ParameterDescription("INT", Long.toString(x)));
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.setParameter(parameterIndex, new ParameterDescription("BOOLEAN", Boolean.toString(x)));
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (!(x instanceof InformationObject)) {
            throw new IllegalArgumentException("Cannot serialize " + x);
        }
        this.setParameter(parameterIndex, new ParameterDescription("INFORMATION_OBJECT", this.serializeInformationObject((InformationObject)x)));
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.setParameter(parameterIndex, new ParameterDescription("URL", x.toString()));
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        DateFormat df = DateFormat.getDateInstance();
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.setParameter(parameterIndex, new ParameterDescription("DATE", df.format(x)));
    }

    protected void setParameter(int pos, ParameterDescription description) {
        this.ensurePositional();
        List<ParameterDescription> params = this.statementDescription.getPositionalParameters();
        if (pos > params.size() + 1) {
            throw new IllegalArgumentException("cannot set parameter " + pos + " because not in order");
        }
        if (pos == params.size() + 1) {
            params.add(description);
            return;
        }
        params.set(pos - 1, description);
    }

    private void ensurePositional() {
        if (this.statementDescription.getPositionalParameters() == null) {
            this.statementDescription.setPositionalParameters(new ArrayList<ParameterDescription>());
        }
        this.statementDescription.setNamedParameters(null);
    }

    private void ensureNamed() {
        if (this.statementDescription.getNamedParameters() == null) {
            this.statementDescription.setNamedParameters(new HashMap<String, ParameterDescription>());
        }
        this.statementDescription.setPositionalParameters(null);
    }

    @Override
    public void addBatch() throws SQLException {
    }

    @Override
    public void clearParameters() throws SQLException {
        this.statementDescription.setPositionalParameters(new ArrayList<ParameterDescription>());
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return null;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return null;
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
    }

    private String serializeInformationObject(InformationObject x) {
        return new Long(x.getId()).toString() + "," + x.getType() + "," + x.getSet();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
    }

    public StatementDescription getStatementDescription() {
        return this.statementDescription;
    }

    public void setStatementDescription(StatementDescription statementDescription) {
        this.statementDescription = statementDescription;
    }
}

