/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dlms.jdbc;

import eu.dnetlib.dlms.jdbc.InformationObjectReference;
import eu.dnetlib.dlms.jdbc.WSRemoteMetaData;
import eu.dnetlib.dlms.jdbc.WSRemoteStatement;
import eu.dnetlib.dlms.jdbc.serialization.CollectionDeserializer;
import eu.dnetlib.dlms.jdbc.serialization.ItemType;
import eu.dnetlib.dlms.jdbc.serialization.ItemWrapper;
import eu.dnetlib.dlms.jdbc.serialization.RSMetadataWrapper;
import eu.dnetlib.enabling.resultset.rmi.ResultSetException;
import eu.dnetlib.enabling.resultset.rmi.ResultSetService;
import eu.dnetlib.miscutils.jaxb.JaxbFactory;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;

public class WSRemoteResultSet
implements ResultSet {
    private final WSRemoteStatement statement;
    private final ResultSetService resultSet;
    private final String rsId;
    private int position = 1;
    private String currentValue;
    private WSRemoteMetaData metaData;
    private CollectionDeserializer collDeserializer = new CollectionDeserializer();

    public void setMetaData(RSMetadataWrapper metaDataWrapper) {
        this.metaData = new WSRemoteMetaData(metaDataWrapper);
    }

    public WSRemoteResultSet(WSRemoteStatement statement, ResultSetService resultSet, String rsId) {
        this.statement = statement;
        this.resultSet = resultSet;
        this.rsId = rsId;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        ItemWrapper item = this.unwrap(this.currentValue);
        if (item.getTypes().get(columnIndex - 1) == ItemType.STRING) {
            return item.getValues().get(columnIndex - 1);
        }
        this.wrongType(ItemType.STRING);
        return null;
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        ItemWrapper item = this.unwrap(this.currentValue);
        if (item.getTypes().get(columnIndex - 1) == ItemType.INT) {
            return Integer.parseInt(item.getValues().get(columnIndex - 1));
        }
        this.wrongType(ItemType.INT);
        return 0;
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        ItemWrapper item = this.unwrap(this.currentValue);
        ItemType it = item.getTypes().get(columnIndex - 1);
        if (it == ItemType.INT || it == ItemType.LONG) {
            return Long.parseLong(item.getValues().get(columnIndex - 1));
        }
        this.wrongType(ItemType.LONG);
        return 0L;
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        ItemWrapper item = this.unwrap(this.currentValue);
        if (item.getTypes().get(columnIndex - 1) == ItemType.BOOLEAN) {
            return Boolean.parseBoolean(item.getValues().get(columnIndex - 1));
        }
        this.wrongType(ItemType.BOOLEAN);
        return false;
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        ItemWrapper item = this.unwrap(this.currentValue);
        if (item.getTypes().get(columnIndex - 1) == ItemType.DATE) {
            return Date.valueOf(item.getValues().get(columnIndex - 1));
        }
        this.wrongType(ItemType.DATE);
        return null;
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        ItemWrapper item = this.unwrap(this.currentValue);
        if (item.getTypes().get(columnIndex - 1) == ItemType.DOUBLE) {
            return Double.parseDouble(item.getValues().get(columnIndex - 1));
        }
        this.wrongType(ItemType.DOUBLE);
        return 0.0;
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        ItemWrapper item = this.unwrap(this.currentValue);
        ItemType it = item.getTypes().get(columnIndex - 1);
        if (it == ItemType.STRING || it == ItemType.URL) {
            try {
                return new URL(item.getValues().get(columnIndex - 1));
            }
            catch (MalformedURLException e) {
                throw new SQLException(e);
            }
        }
        this.wrongType(ItemType.URL);
        return null;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        if (this.currentValue == null) {
            return null;
        }
        ItemWrapper item = this.unwrap(this.currentValue);
        String value = item.getValues().get(columnIndex - 1);
        if (value == null || value.trim().isEmpty()) {
            return null;
        }
        return this.deserialize(item.getValues().get(columnIndex - 1), item.getTypes().get(columnIndex - 1));
    }

    private Object deserialize(String columnValue, ItemType columnType) {
        switch (columnType) {
            case INFORMATION_OBJECT: {
                return new InformationObjectReference(columnValue);
            }
            case BOOLEAN: {
                return Boolean.parseBoolean(columnValue);
            }
            case DATE: {
                return Date.valueOf(columnValue);
            }
            case DOUBLE: {
                return Double.parseDouble(columnValue);
            }
            case STRING: {
                return columnValue;
            }
            case URL: {
                try {
                    return new URL(columnValue);
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException("Malformed URL: " + columnValue, e);
                }
            }
            case INT: {
                return Integer.parseInt(columnValue);
            }
            case LONG: {
                return Long.parseLong(columnValue);
            }
            case COLL: {
                return this.collDeserializer.deserialize(columnValue);
            }
        }
        throw new RuntimeException("Cannot deserialize " + columnValue + " : unknown type " + (Object)((Object)columnType));
    }

    @Override
    public boolean next() throws SQLException {
        try {
            List res = this.resultSet.getResult(this.rsId, this.position, this.position, "waiting");
            if (res == null || res.isEmpty()) {
                return false;
            }
            this.currentValue = (String)res.get(0);
            System.out.println("currentValue set to " + this.currentValue);
            ++this.position;
            return true;
        }
        catch (ResultSetException e) {
            throw new SQLException("cannot fetch result", e);
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.metaData == null) {
            try {
                List res = this.resultSet.getResult(this.rsId, 0, 0, "waiting");
                if (res == null || res.isEmpty()) {
                    throw new SQLException("cannot fetch resultset metadata: resultList from " + this.resultSet + " is null or empty");
                }
                String metadataSer = (String)res.get(0);
                this.setMetaData(this.unwrapMetaData(metadataSer));
            }
            catch (ResultSetException e) {
                throw new SQLException("cannot fetch resultset metadata", e);
            }
        }
        return this.metaData;
    }

    private void wrongType(ItemType type) throws SQLException {
        throw new SQLException("Wrong type, expected: " + (Object)((Object)type));
    }

    private void unimplemented() throws SQLException {
        throw new SQLException("Currently unimplemented, stay tuned");
    }

    public ItemWrapper unwrap(String item) {
        try {
            JaxbFactory factory = new JaxbFactory(ItemWrapper.class);
            return (ItemWrapper)factory.parse(item);
        }
        catch (JAXBException e) {
            throw new IllegalStateException("cannot deserialize item wrapper", e);
        }
    }

    public RSMetadataWrapper unwrapMetaData(String metadata) {
        try {
            JaxbFactory factory = new JaxbFactory(RSMetadataWrapper.class);
            return (RSMetadataWrapper)factory.parse(metadata);
        }
        catch (JAXBException e) {
            throw new IllegalStateException("cannot deserialize metadata wrapper", e);
        }
    }

    public void setMetaData(WSRemoteMetaData metaData) {
        this.metaData = metaData;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.unimplemented();
        return false;
    }

    @Override
    public void afterLast() throws SQLException {
        this.unimplemented();
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.unimplemented();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.unimplemented();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.unimplemented();
    }

    @Override
    public void close() throws SQLException {
    }

    @Override
    public void deleteRow() throws SQLException {
        this.unimplemented();
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        this.unimplemented();
        return 0;
    }

    @Override
    public boolean first() throws SQLException {
        this.unimplemented();
        return false;
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        this.unimplemented();
        return null;
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.unimplemented();
        return null;
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        this.unimplemented();
        return null;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.unimplemented();
        return null;
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        this.unimplemented();
        return null;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        this.unimplemented();
        return null;
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        this.unimplemented();
        return null;
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.unimplemented();
        return null;
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        this.unimplemented();
        return null;
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        this.unimplemented();
        return null;
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        this.unimplemented();
        return null;
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        this.unimplemented();
        return false;
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.unimplemented();
        return 0;
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        this.unimplemented();
        return 0;
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.unimplemented();
        return null;
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        this.unimplemented();
        return null;
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        this.unimplemented();
        return null;
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        this.unimplemented();
        return null;
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        this.unimplemented();
        return null;
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        this.unimplemented();
        return null;
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.unimplemented();
        return 0;
    }

    @Override
    public String getCursorName() throws SQLException {
        this.unimplemented();
        return null;
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        this.unimplemented();
        return null;
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        this.unimplemented();
        return null;
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        this.unimplemented();
        return null;
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        this.unimplemented();
        return 0.0;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.unimplemented();
        return 0;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.unimplemented();
        return 0;
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.unimplemented();
        return 0.0f;
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        this.unimplemented();
        return 0.0f;
    }

    @Override
    public int getHoldability() throws SQLException {
        this.unimplemented();
        return 0;
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        this.unimplemented();
        return 0;
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        this.unimplemented();
        return 0L;
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        this.unimplemented();
        return null;
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        this.unimplemented();
        return null;
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        this.unimplemented();
        return null;
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        this.unimplemented();
        return null;
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        this.unimplemented();
        return null;
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        this.unimplemented();
        return null;
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        this.unimplemented();
        return null;
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        this.unimplemented();
        return null;
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        this.unimplemented();
        return null;
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        this.unimplemented();
        return null;
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        this.unimplemented();
        return null;
    }

    @Override
    public int getRow() throws SQLException {
        return this.position - 1;
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        this.unimplemented();
        return null;
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        this.unimplemented();
        return null;
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        this.unimplemented();
        return null;
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        this.unimplemented();
        return null;
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.unimplemented();
        return 0;
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        this.unimplemented();
        return 0;
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        this.unimplemented();
        return null;
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.unimplemented();
        return null;
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        this.unimplemented();
        return null;
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        this.unimplemented();
        return null;
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        this.unimplemented();
        return null;
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.unimplemented();
        return null;
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        this.unimplemented();
        return null;
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        this.unimplemented();
        return null;
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        this.unimplemented();
        return null;
    }

    @Override
    public int getType() throws SQLException {
        this.unimplemented();
        return 0;
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        this.unimplemented();
        return null;
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        this.unimplemented();
        return null;
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        this.unimplemented();
        return null;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.unimplemented();
        return null;
    }

    @Override
    public void insertRow() throws SQLException {
        this.unimplemented();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.unimplemented();
        return false;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.unimplemented();
        return false;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.unimplemented();
        return false;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.unimplemented();
        return false;
    }

    @Override
    public boolean last() throws SQLException {
        this.unimplemented();
        return false;
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.unimplemented();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.unimplemented();
    }

    @Override
    public boolean previous() throws SQLException {
        this.unimplemented();
        return false;
    }

    @Override
    public void refreshRow() throws SQLException {
        this.unimplemented();
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.unimplemented();
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.unimplemented();
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.unimplemented();
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateRow() throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.unimplemented();
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        this.unimplemented();
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.unimplemented();
        return false;
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        this.unimplemented();
        return null;
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        this.unimplemented();
        return null;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public String getCurrentValue() {
        return this.currentValue;
    }

    public void setCurrentValue(String currentValue) {
        this.currentValue = currentValue;
    }
}

