/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dlms.jdbc;

import eu.dnetlib.dlms.jdbc.WSRemoteConnection;
import eu.dnetlib.dlms.jdbc.WSRemoteResultSet;
import eu.dnetlib.dlms.rmi.DLMSBrokenConnectionException;
import eu.dnetlib.dlms.rmi.DLMSBrokenConnectionRuntimeException;
import eu.dnetlib.dlms.rmi.DLMSConnectionException;
import eu.dnetlib.dlms.rmi.DLMSConnectionRuntimeException;
import eu.dnetlib.dlms.rmi.StatementDescription;
import eu.dnetlib.enabling.resultset.rmi.ResultSetService;
import eu.dnetlib.enabling.tools.ServiceResolver;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

public class WSRemoteStatement
implements Statement {
    private final WSRemoteConnection connection;
    private ResultSetService resultSet;
    private String rsId;
    private final ServiceResolver serviceResolver;

    public WSRemoteStatement(ServiceResolver serviceResolver, WSRemoteConnection connection) {
        this.serviceResolver = serviceResolver;
        this.connection = connection;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (this.resultSet == null) {
            throw new SQLException("statement not executed yet, cannot get resultset");
        }
        return new WSRemoteResultSet(this, this.resultSet, this.rsId);
    }

    @Override
    public boolean execute(String source) throws SQLException {
        StatementDescription statement = new StatementDescription();
        statement.setSource(source);
        this.remoteExecute(statement);
        return true;
    }

    @Override
    public ResultSet executeQuery(String source) throws SQLException {
        if (this.execute(source)) {
            return this.getResultSet();
        }
        throw new SQLException("Cannot get ResultSet for " + source);
    }

    protected void remoteExecute(StatementDescription statement) {
        try {
            W3CEndpointReference epr = this.connection.getConnectionService().executeStatement(this.connection.getConnectionId(), statement);
            this.resultSet = (ResultSetService)this.serviceResolver.getService(ResultSetService.class, epr);
            this.rsId = this.serviceResolver.getResourceIdentifier(epr);
        }
        catch (DLMSBrokenConnectionException e) {
            throw new DLMSBrokenConnectionRuntimeException(e.getMessage(), e.getCause());
        }
        catch (DLMSConnectionException e) {
            throw new DLMSConnectionRuntimeException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public void addBatch(String arg0) throws SQLException {
    }

    @Override
    public void cancel() throws SQLException {
    }

    @Override
    public void clearBatch() throws SQLException {
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void close() throws SQLException {
    }

    @Override
    public boolean execute(String arg0, int arg1) throws SQLException {
        return false;
    }

    @Override
    public boolean execute(String arg0, int[] arg1) throws SQLException {
        return false;
    }

    @Override
    public boolean execute(String arg0, String[] arg1) throws SQLException {
        return false;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return null;
    }

    @Override
    public int executeUpdate(String arg0) throws SQLException {
        return 0;
    }

    @Override
    public int executeUpdate(String arg0, int arg1) throws SQLException {
        return 0;
    }

    @Override
    public int executeUpdate(String arg0, int[] arg1) throws SQLException {
        return 0;
    }

    @Override
    public int executeUpdate(String arg0, String[] arg1) throws SQLException {
        return 0;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return null;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 0;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return null;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxRows() throws SQLException {
        return 0;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return false;
    }

    @Override
    public boolean getMoreResults(int arg0) throws SQLException {
        return false;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return 0;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return 0;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 0;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 0;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void setCursorName(String arg0) throws SQLException {
    }

    @Override
    public void setEscapeProcessing(boolean arg0) throws SQLException {
    }

    @Override
    public void setFetchDirection(int arg0) throws SQLException {
    }

    @Override
    public void setFetchSize(int arg0) throws SQLException {
    }

    @Override
    public void setMaxFieldSize(int arg0) throws SQLException {
    }

    @Override
    public void setMaxRows(int arg0) throws SQLException {
    }

    @Override
    public void setPoolable(boolean arg0) throws SQLException {
    }

    @Override
    public void setQueryTimeout(int arg0) throws SQLException {
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        return null;
    }
}

