/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dlms.jdbc.serialization;

import eu.dnetlib.dlms.jdbc.serialization.ItemType;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class CollectionDeserializer {
    public Object deserialize(String serializedColl) {
        String[] collSplitted = serializedColl.split("\\|");
        String collContent = collSplitted[0];
        ItemType contentType = ItemType.valueOf(collSplitted[1].trim());
        switch (contentType) {
            case BOOLEAN: {
                return this.deserializeCollBoolean(collContent);
            }
            case DATE: {
                return this.deserializeCollDate(collContent);
            }
            case DOUBLE: {
                return this.deserializeCollDouble(collContent);
            }
            case INT: {
                return this.deserializeCollInteger(collContent);
            }
            case LONG: {
                return this.deserializeCollLong(collContent);
            }
            case STRING: 
            case URL: {
                return this.deserializeCollString(collContent);
            }
            case COLL: {
                break;
            }
            case D: {
                return this.deserializeCollD(collContent);
            }
            case INFORMATION_OBJECT: {
                throw new RuntimeException("Unexpected type in collection field: INFORMATION_OBJECT");
            }
            default: {
                throw new RuntimeException("Unknown type in collection field: " + (Object)((Object)contentType));
            }
        }
        return null;
    }

    Collection<Map<String, Object>> deserializeCollD(String serializedColl) {
        String valueNoBrackets = serializedColl.substring(1, serializedColl.length() - 1).trim();
        ArrayList<Map<String, Object>> res = new ArrayList<Map<String, Object>>();
        Object[] collEls = valueNoBrackets.split("},");
        System.out.println("collEls is: " + Arrays.toString(collEls));
        for (Object el : collEls) {
            String[] couples;
            HashMap<String, String> elMap = new HashMap<String, String>();
            el = ((String)el).replaceFirst("\\s?\\{\\s?", " ");
            el = ((String)el).replaceFirst("\\s?}\\s?", " ");
            System.out.println("El in collEls: " + (String)el);
            for (String c : couples = ((String)el).split(",")) {
                String[] coupleSplitted = c.split("\\s?=\\s?");
                elMap.put(coupleSplitted[0].trim(), coupleSplitted[1].trim());
            }
            res.add(elMap);
        }
        return res;
    }

    Collection<String> deserializeCollString(String serializedColl) {
        String[] els;
        String valueNoBrackets = serializedColl.substring(1, serializedColl.length() - 1).trim();
        ArrayList<String> res = new ArrayList<String>();
        for (String el : els = valueNoBrackets.split(",")) {
            res.add(el.trim());
        }
        return res;
    }

    Collection<Boolean> deserializeCollBoolean(String serializedColl) {
        String[] els;
        String valueNoBrackets = serializedColl.substring(1, serializedColl.length() - 1).trim();
        ArrayList<Boolean> res = new ArrayList<Boolean>();
        for (String el : els = valueNoBrackets.split(",")) {
            res.add(Boolean.parseBoolean(el));
        }
        return res;
    }

    Collection<Double> deserializeCollDouble(String serializedColl) {
        String[] els;
        String valueNoBrackets = serializedColl.substring(1, serializedColl.length() - 1).trim();
        ArrayList<Double> res = new ArrayList<Double>();
        for (String el : els = valueNoBrackets.split(",")) {
            res.add(Double.parseDouble(el));
        }
        return res;
    }

    Collection<Integer> deserializeCollInteger(String serializedColl) {
        String[] els;
        String valueNoBrackets = serializedColl.substring(1, serializedColl.length() - 1).trim();
        ArrayList<Integer> res = new ArrayList<Integer>();
        for (String el : els = valueNoBrackets.split(",")) {
            res.add(Integer.parseInt(el));
        }
        return res;
    }

    Collection<Long> deserializeCollLong(String serializedColl) {
        String[] els;
        String valueNoBrackets = serializedColl.substring(1, serializedColl.length() - 1).trim();
        ArrayList<Long> res = new ArrayList<Long>();
        for (String el : els = valueNoBrackets.split(",")) {
            res.add(Long.parseLong(el));
        }
        return res;
    }

    Collection<Date> deserializeCollDate(String serializedColl) {
        String[] els;
        String valueNoBrackets = serializedColl.substring(1, serializedColl.length() - 1).trim();
        ArrayList<Date> res = new ArrayList<Date>();
        for (String el : els = valueNoBrackets.split(",")) {
            res.add(Date.valueOf(el));
        }
        return res;
    }

    Collection<? extends Object> deserializeCollColl(String serializedColl) {
        throw new RuntimeException("Returning fields of tyoe coll(coll(type)) is not yet implemented");
    }
}

