package eu.dnetlib.actionmanager.blackboard;

import java.util.concurrent.Callable;

import eu.dnetlib.actionmanager.rmi.ActionManagerException;
import eu.dnetlib.actionmanager.wf.ActionManagerWorkflowLauncher;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerAction;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;

public class DeleteActionManagerAction extends AbstractActionManagerAction implements BlackboardServerAction<ActionManagerActions> {

	//	<MESSAGE id="bb-1234" date="2012-11-06T15:10:56+01:00">
	//		<ACTION>DELETE</ACTION>
	//		<PARAMETER name="set" value=""/>
	//		<ACTION_STATUS>ASSIGNED</ACTION_STATUS>
	//	</MESSAGE>

	@Override
	public void execute(final BlackboardServerHandler handler, final BlackboardJob job) {

		String set = job.getParameters().get("set");
		if (set == null || set.isEmpty()) {
			set = ActionManagerWorkflowLauncher.ALL_SETS;
		}

		try {
			getActionManagerWorkflowLauncher().executeDelete(set, new Callable<String>() {
				@Override
				public String call() {
					handler.done(job);
					return "done";
				}
			}, new Callable<String>() {
				@Override
				public String call() {
					handler.failed(job, new ActionManagerException("MSRO Workwlow is failed"));
					return "failed";
				}
			});
		} catch (Exception e) {
			handler.failed(job, e);
		}
	}

}
