package eu.dnetlib.actionmanager.blackboard;

import javax.annotation.Resource;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.actionmanager.common.Operation;
import eu.dnetlib.actionmanager.common.Provenance;
import eu.dnetlib.actionmanager.rmi.ActionManagerException;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerAction;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;

// TODO: Auto-generated Javadoc
/**
 * The Class FeedActionManagerAction.
 */
public class FeedActionManagerAction extends AbstractActionManagerAction implements BlackboardServerAction<ActionManagerActions> {

	/** The Constant log. */
	private static final Log log = LogFactory.getLog(FeedActionManagerAction.class);

	/** The result set client factory. */
	@Resource
	private ResultSetClientFactory resultSetClientFactory;

	/**
	 * input parameters: epr: result-set end point reference containg the set of package info ruleId: one of the rules
	 * available to apply set: the destination set for the current info-packages provenance: the source of the
	 * info-packages fed trust: trust level nsprefix: namespace prefix agentID agentType.
	 * 
	 * @param handler
	 *            the handler
	 * @param job
	 *            the job
	 */
	@Override
	public void execute(BlackboardServerHandler handler, BlackboardJob job) {
		log.debug("Inside execute" + this.getClass().getSimpleName());

		String epr = job.getParameters().get("epr");
		String ruleId = job.getParameters().get("ruleId");
		String set = job.getParameters().get("set");
		Provenance provenance = Provenance.convert(job.getParameters().get("provenance"));
		String trust = job.getParameters().get("trust");
		String nsprefix = job.getParameters().get("nsprefix");
		String agentID = job.getParameters().get("agentId");
		String agentName = job.getParameters().get("agentName");
		String agentType = job.getParameters().get("agentType");

		int n = 0;
		try {
			n = feed(epr, ruleId, set, provenance, trust, nsprefix, agentID, agentName, agentType);
		} catch (ActionManagerException e) {
			handler.failed(job, e);
			return;
		}

		log.debug("Actions added: " + n);
		handler.done(job);
	}

	/**
	 * Feed.
	 * 
	 * @param epr
	 *            the epr
	 * @param ruleId
	 *            the rule id
	 * @param set
	 *            the set
	 * @param provenance
	 *            the provenance
	 * @param trust
	 *            the trust
	 * @param nsprefix
	 *            the nsprefix
	 * @param agentID
	 *            the agent id
	 * @param agentType
	 *            the agent type
	 * @return the int
	 * @throws ActionManagerException
	 *             the action manager exception
	 */
	private int feed(
			String epr,
			String ruleId,
			String set,
			Provenance provenance,
			String trust,
			String nsprefix,
			String agentID,
			String agentName,
			String agentType

	) throws ActionManagerException {
		String decodeEPR = new String(Base64.decodeBase64(epr));

		final Iterable<String> records = resultSetClientFactory.getClient(decodeEPR);
		int n = 0;
		Agent agent = new Agent();
		agent.setId(agentID);
		agent.setName(agentName);
		agent.setType(Agent.AGENT_TYPE.valueOf(agentType));
		for (String infoPackage : records) {
			if (infoPackage != null) {
				n += core.applyInfoPackageAction(ruleId, set, agent, Operation.INSERT, infoPackage, provenance, trust, nsprefix);
			}
		}
		return n;
	}
}
