package eu.dnetlib.actionmanager.hack;

import java.io.StringWriter;

import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.Resource;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.database.rmi.DatabaseService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.workflow.AsyncJobNode;

public class PerformSQLJobNode extends AsyncJobNode {

	private ServiceLocator<DatabaseService> dbServiceLocator;

	private String dbName;

	private Resource query;

	private Resource countQuery;

	private Resource xslt;

	private static final Log log = LogFactory.getLog(PerformSQLJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Override
	public void executeAsync(final Engine engine, final NodeToken token) {
		final StringWriter q = new StringWriter();
		final StringWriter cq = new StringWriter();
		final StringWriter xs = new StringWriter();

		try {
			IOUtils.copy(query.getInputStream(), q);
			IOUtils.copy(countQuery.getInputStream(), cq);
			IOUtils.copy(xslt.getInputStream(), xs);

			log.info("Executing query [" + q + "] on db " + dbName);
			W3CEndpointReference epr = getDbServiceLocator().getService().alternativeXsltSearchSQL(dbName, q.toString(), cq.toString(), xs.toString());
			log.info("Optained epr: " + epr);

			token.getEnv().setTransientAttribute("epr", epr);
			engine.complete(token, Arc.DEFAULT_ARC);
		} catch (Throwable e) {
			failed(engine, token, e);
		}
	}

	public String getDbName() {
		return dbName;
	}

	@Required
	public void setDbName(String dbName) {
		this.dbName = dbName;
	}

	public ServiceLocator<DatabaseService> getDbServiceLocator() {
		return dbServiceLocator;
	}

	@Required
	public void setDbServiceLocator(ServiceLocator<DatabaseService> dbServiceLocator) {
		this.dbServiceLocator = dbServiceLocator;
	}

	public Resource getQuery() {
		return query;
	}

	@Required
	public void setQuery(Resource query) {
		this.query = query;
	}

	public Resource getCountQuery() {
		return countQuery;
	}

	@Required
	public void setCountQuery(Resource countQuery) {
		this.countQuery = countQuery;
	}

	public Resource getXslt() {
		return xslt;
	}

	@Required
	public void setXslt(Resource xslt) {
		this.xslt = xslt;
	}

}