/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.actionmanager.hbase;

import com.google.common.collect.Lists;
import eu.dnetlib.actionmanager.actions.ActionFactory;
import eu.dnetlib.actionmanager.actions.XsltInfoPackageAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.actionmanager.common.Operation;
import eu.dnetlib.actionmanager.common.Provenance;
import eu.dnetlib.actionmanager.hbase.HBaseClient;
import eu.dnetlib.actionmanager.is.ISClient;
import eu.dnetlib.actionmanager.rmi.ActionManagerException;
import eu.dnetlib.actionmanager.set.ActionManagerSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.util.Bytes;
import org.springframework.beans.factory.annotation.Required;

public class HBaseActionManagerCore {
    private ActionFactory actionFactory;
    private HBaseClient hbaseClient;
    private ISClient informationServiceClient;

    public int applyInfoPackageAction(String splitRuleId, String set, Agent agent, Operation operation, String infoPackage, Provenance provenance, String trust, String nsprefix) throws ActionManagerException {
        if (this.informationServiceClient.existsSet(set)) {
            XsltInfoPackageAction action = this.actionFactory.generateInfoPackageAction(splitRuleId, set, agent, operation, infoPackage);
            List puts = action.asPutOperations(null, provenance, trust, nsprefix);
            this.hbaseClient.write(puts);
            return puts.size();
        }
        throw new ActionManagerException("Missing set " + set);
    }

    public int applyInfoPackageAction(String splitRuleId, String set, Agent agent, Operation operation, String infoPackage, Provenance provenance, String trust, String nsprefix, HTable table) throws ActionManagerException {
        if (this.informationServiceClient.existsSet(set)) {
            XsltInfoPackageAction action = this.actionFactory.generateInfoPackageAction(splitRuleId, set, agent, operation, infoPackage);
            List puts = action.asPutOperations(null, provenance, trust, nsprefix);
            this.hbaseClient.write(puts, table);
            return puts.size();
        }
        throw new ActionManagerException("Missing set " + set);
    }

    public void deleteInfoPackageAction(String id) throws ActionManagerException {
        Map<String, String> row = this.hbaseClient.getRow(Bytes.toBytes((String)id));
        ArrayList deletes = Lists.newArrayList();
        for (String key : row.keySet()) {
            if (!key.startsWith("rel:")) continue;
            deletes.add(new Delete(Bytes.toBytes((String)key.substring(4))));
        }
        deletes.add(new Delete(Bytes.toBytes((String)id)));
        this.hbaseClient.delete(deletes);
    }

    public ActionFactory getActionFactory() {
        return this.actionFactory;
    }

    @Required
    public void setActionFactory(ActionFactory actionFactory) {
        this.actionFactory = actionFactory;
    }

    public HBaseClient getHbaseClient() {
        return this.hbaseClient;
    }

    @Required
    public void setHbaseClient(HBaseClient hbaseClient) {
        this.hbaseClient = hbaseClient;
    }

    public List<ActionManagerSet> listAvailableSets() {
        return this.informationServiceClient.listSets();
    }

    public ISClient getInformationServiceClient() {
        return this.informationServiceClient;
    }

    @Required
    public void setInformationServiceClient(ISClient informationServiceClient) {
        this.informationServiceClient = informationServiceClient;
    }
}

