/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.actionmanager.is;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import eu.dnetlib.actionmanager.rmi.ActionManagerException;
import eu.dnetlib.actionmanager.set.ActionManagerSet;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryException;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.soap.EndpointReferenceBuilder;
import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.Endpoint;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class ISClient {
    private ServiceLocator<ISRegistryService> registryLocator;
    private ServiceLocator<ISLookUpService> lookupLocator;
    private StringTemplate actionManagerSetDsTemplate;
    private Endpoint endpoint;
    private EndpointReferenceBuilder<Endpoint> eprBuilder;
    private static final Log log = LogFactory.getLog(ISClient.class);

    public String registerSetProfile(ActionManagerSet set) throws ActionManagerException {
        if (this.existsSet(set.getId())) {
            throw new ActionManagerException("Set " + set.getId() + " already registered");
        }
        try {
            StringTemplate template = new StringTemplate(this.actionManagerSetDsTemplate.getTemplate());
            template.setAttribute("serviceUri", (Object)this.eprBuilder.getAddress((Object)this.endpoint));
            template.setAttribute("set", (Object)set);
            return ((ISRegistryService)this.registryLocator.getService()).registerProfile(template.toString());
        }
        catch (ISRegistryException e) {
            throw new ActionManagerException("Error registering set " + set, (Throwable)e);
        }
    }

    public List<ActionManagerSet> listSets() {
        String q = "for $x in collection('/db/DRIVER/ActionManagerSetDSResources/ActionManagerSetDSResourceType') return concat(' ', $x//SET/@id, ' @@@ ', $x//SET/text(), ' @@@ ', $x//IMPACT, ' @@@ ', $x//LAST_EXECUTION_DATE, ' ')";
        try {
            return Lists.newArrayList((Iterable)Lists.transform((List)((ISLookUpService)this.lookupLocator.getService()).quickSearchProfile(q), (Function)new Function<String, ActionManagerSet>(){

                public ActionManagerSet apply(String s) {
                    ArrayList list = Lists.newArrayList((Iterable)Splitter.on((String)"@@@").split((CharSequence)s));
                    return new ActionManagerSet(((String)list.get(0)).trim(), ((String)list.get(1)).trim(), ActionManagerSet.ImpactTypes.valueOf((String)((String)list.get(2)).trim()), ((String)list.get(3)).trim());
                }
            }));
        }
        catch (ISLookUpException e) {
            log.error((Object)"Error accessing Sets");
            return Lists.newArrayList();
        }
    }

    public boolean existsSet(String id) {
        String q = "for $x in collection('/db/DRIVER/ActionManagerSetDSResources/ActionManagerSetDSResourceType') where $x//SET/@id = '" + id + "' return $x";
        try {
            return !((ISLookUpService)this.lookupLocator.getService()).quickSearchProfile(q).isEmpty();
        }
        catch (ISLookUpException e) {
            log.error((Object)"Error accessing Sets");
            return false;
        }
    }

    public StringTemplate getActionManagerSetDsTemplate() {
        return this.actionManagerSetDsTemplate;
    }

    @Required
    public void setActionManagerSetDsTemplate(StringTemplate actionManagerSetDsTemplate) {
        this.actionManagerSetDsTemplate = actionManagerSetDsTemplate;
    }

    public ServiceLocator<ISRegistryService> getRegistryLocator() {
        return this.registryLocator;
    }

    @Required
    public void setRegistryLocator(ServiceLocator<ISRegistryService> registryLocator) {
        this.registryLocator = registryLocator;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    @Required
    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public EndpointReferenceBuilder<Endpoint> getEprBuilder() {
        return this.eprBuilder;
    }

    @Required
    public void setEprBuilder(EndpointReferenceBuilder<Endpoint> eprBuilder) {
        this.eprBuilder = eprBuilder;
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    @Required
    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }
}

