package eu.dnetlib.actionmanager;

import java.util.List;

import javax.jws.WebParam;

import org.springframework.beans.factory.annotation.Required;

import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.actionmanager.common.Operation;
import eu.dnetlib.actionmanager.common.Provenance;
import eu.dnetlib.actionmanager.hbase.HBaseActionManagerCore;
import eu.dnetlib.actionmanager.rmi.ActionManagerException;
import eu.dnetlib.actionmanager.rmi.ActionManagerService;
import eu.dnetlib.actionmanager.set.ActionManagerSet;
import eu.dnetlib.enabling.tools.AbstractBaseService;
import eu.dnetlib.enabling.tools.blackboard.NotificationHandler;

public class ActionManagerServiceImpl extends AbstractBaseService implements ActionManagerService {

	private HBaseActionManagerCore core;

	private NotificationHandler notificationHandler;

	@Override
	public String createSet(@WebParam(name = "set") ActionManagerSet set) throws ActionManagerException {
		return core.getInformationServiceClient().registerSetProfile(set);
	}

	@Override
	public List<ActionManagerSet> ListSets() throws ActionManagerException {
		return core.listAvailableSets();
	}

	@Override
	public int createAction(
			String splitRuleId,
			String set,
			Agent agent,
			Operation operation,
			String infoPackage,
			Provenance provenance,
			String trust,
			String nsprefix) throws ActionManagerException {
		return core.applyInfoPackageAction(splitRuleId, set, agent, operation, infoPackage, provenance, trust, nsprefix);
	}

	@Override
	public int updateAction(
			String actionId,
			String splitRuleId,
			String set,
			Agent agent,
			Operation operation,
			String infoPackage,
			Provenance provenance,
			String trust,
			String nsprefix) throws ActionManagerException {

		core.deleteInfoPackageAction(actionId);

		return core.applyInfoPackageAction(splitRuleId, set, agent, operation, infoPackage, provenance, trust, nsprefix);
	}

	@Override
	public boolean deleteAction(String actionId) throws ActionManagerException {
		core.deleteInfoPackageAction(actionId);
		return true;
	}

	@Override
	public List<String> getActionsByAgent(String agentId, int limit) throws ActionManagerException {
		return core.getHbaseClient().retrieveActionsByAgent(agentId, limit);
	}

	@Override
	public void notify(final String subscriptionId, final String topic, final String isId, final String message) {
		notificationHandler.notified(subscriptionId, topic, isId, message);
	}

	public HBaseActionManagerCore getCore() {
		return core;
	}

	public void setCore(HBaseActionManagerCore core) {
		this.core = core;
	}

	public NotificationHandler getNotificationHandler() {
		return notificationHandler;
	}

	@Required
	public void setNotificationHandler(NotificationHandler notificationHandler) {
		this.notificationHandler = notificationHandler;
	}

}
