/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.actionmanager.wf;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.Graph;
import com.googlecode.sarasvati.GraphProcess;
import com.googlecode.sarasvati.mem.MemGraphProcess;
import eu.dnetlib.actionmanager.is.ISClient;
import eu.dnetlib.actionmanager.rmi.ActionManagerException;
import eu.dnetlib.workflow.GraphProcessRegistry;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class ActionManagerWorkflowLauncher {
    private GraphProcessRegistry processRegistry;
    private Graph commitGraph;
    private Graph deleteGraph;
    private Executor executor = Executors.newCachedThreadPool();
    private ISClient infomationServiceClient;
    @Resource
    private transient Engine engine;
    private String actionTable;
    private String dataTable;
    private static final Log log = LogFactory.getLog(ActionManagerWorkflowLauncher.class);
    public static final String ALL_SETS = "__ALL__";

    public void executeDelete(String set, Callable<?> callbackCompleted, Callable<?> callbackFailed) throws ActionManagerException {
        log.info((Object)("Starting clean-wf; set=" + set));
        this.execute(this.deleteGraph, set, callbackCompleted, callbackFailed);
    }

    public void executeCommit(String set, Callable<?> callbackCompleted, Callable<?> callbackFailed) throws ActionManagerException {
        log.info((Object)("Starting commit-wf; set=" + set));
        this.execute(this.commitGraph, set, callbackCompleted, callbackFailed);
    }

    private void execute(final Graph graph, final String set, final Callable<?> callbackCompleted, final Callable<?> callbackFailed) throws ActionManagerException {
        if (set != null && !set.equals(ALL_SETS) && !this.infomationServiceClient.existsSet(set)) {
            throw new ActionManagerException("Missing set " + set);
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                MemGraphProcess process = new MemGraphProcess(graph);
                ActionManagerWorkflowLauncher.this.processRegistry.registerProcess((GraphProcess)process);
                if (set != null && !set.equals(ActionManagerWorkflowLauncher.ALL_SETS)) {
                    process.getEnv().setAttribute("set", set);
                }
                process.getEnv().setAttribute("actionTable", ActionManagerWorkflowLauncher.this.actionTable);
                process.getEnv().setAttribute("dataTable", ActionManagerWorkflowLauncher.this.dataTable);
                process.getEnv().setTransientAttribute("callbackCompleted", (Object)callbackCompleted);
                process.getEnv().setTransientAttribute("callbackFailed", (Object)callbackFailed);
                ActionManagerWorkflowLauncher.this.engine.startProcess((GraphProcess)process);
            }
        });
    }

    public Engine getEngine() {
        return this.engine;
    }

    public void setEngine(Engine engine) {
        this.engine = engine;
    }

    public Graph getCommitGraph() {
        return this.commitGraph;
    }

    @Required
    public void setCommitGraph(Graph commitGraph) {
        this.commitGraph = commitGraph;
    }

    public Graph getDeleteGraph() {
        return this.deleteGraph;
    }

    @Required
    public void setDeleteGraph(Graph deleteGraph) {
        this.deleteGraph = deleteGraph;
    }

    public String getActionTable() {
        return this.actionTable;
    }

    @Required
    public void setActionTable(String actionTable) {
        this.actionTable = actionTable;
    }

    public String getDataTable() {
        return this.dataTable;
    }

    @Required
    public void setDataTable(String dataTable) {
        this.dataTable = dataTable;
    }

    public GraphProcessRegistry getProcessRegistry() {
        return this.processRegistry;
    }

    @Required
    public void setProcessRegistry(GraphProcessRegistry processRegistry) {
        this.processRegistry = processRegistry;
    }

    public ISClient getInfomationServiceClient() {
        return this.infomationServiceClient;
    }

    @Required
    public void setInfomationServiceClient(ISClient infomationServiceClient) {
        this.infomationServiceClient = infomationServiceClient;
    }
}

