package eu.dnetlib.actionmanager.blackboard;

import java.util.concurrent.Callable;

import eu.dnetlib.actionmanager.rmi.ActionManagerException;
import eu.dnetlib.actionmanager.wf.ActionManagerWorkflowLauncher;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerAction;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;

public class PromoteActionManagerAction extends AbstractActionManagerAction implements BlackboardServerAction<ActionManagerActions> {

	@Override
	public void execute(final BlackboardServerHandler handler, final BlackboardJob job) {

		String set = job.getParameters().get("set");
		if (set == null || set.isEmpty()) {
			set = ActionManagerWorkflowLauncher.ALL_SETS;
		}

		try {
			getActionManagerWorkflowLauncher().executeCommit(set, new Callable<String>() {
				@Override
				public String call() {
					handler.done(job);
					return "done";
				}
			}, new Callable<String>() {
				@Override
				public String call() {
					handler.failed(job, new ActionManagerException("MSRO Workwlow is failed"));
					return "failed";
				}
			});
		} catch (Exception e) {
			handler.failed(job, e);
		}

	}
}
