package eu.dnetlib.actionmanager.hack;

import org.springframework.beans.factory.annotation.Required;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.actionmanager.hbase.HBaseActionManagerCore;
import eu.dnetlib.actionmanager.set.ActionManagerSet;
import eu.dnetlib.workflow.AsyncJobNode;

public class RegisterMissingSets extends AsyncJobNode {

	private HBaseActionManagerCore core;

	@Override
	protected void executeAsync(Engine engine, NodeToken token) {
		try {
			for (RequiredSet rs : RequiredSet.values()) {
				String set = rs.toString();
				if (!core.getInformationServiceClient().existsSet(set.toString())) {
					core.getInformationServiceClient().registerSetProfile(new ActionManagerSet(set, set));
				}
			}
			engine.complete(token, Arc.DEFAULT_ARC);
		} catch (Throwable e) {
			failed(engine, token, e);
		}
	}

	public HBaseActionManagerCore getCore() {
		return core;
	}

	@Required
	public void setCore(HBaseActionManagerCore core) {
		this.core = core;
	}

}
