/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.actionmanager.hack;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.database.rmi.DatabaseService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.workflow.AsyncJobNode;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.Resource;

public class PerformSQLJobNode
extends AsyncJobNode {
    private ServiceLocator<DatabaseService> dbServiceLocator;
    private String dbName;
    private Resource query;
    private Resource countQuery;
    private Resource xslt;
    private static final Log log = LogFactory.getLog(PerformSQLJobNode.class);

    public void executeAsync(Engine engine, NodeToken token) {
        StringWriter q = new StringWriter();
        StringWriter cq = new StringWriter();
        StringWriter xs = new StringWriter();
        try {
            IOUtils.copy((InputStream)this.query.getInputStream(), (Writer)q);
            IOUtils.copy((InputStream)this.countQuery.getInputStream(), (Writer)cq);
            IOUtils.copy((InputStream)this.xslt.getInputStream(), (Writer)xs);
            log.info((Object)("Executing query [" + q + "] on db " + this.dbName));
            W3CEndpointReference epr = ((DatabaseService)this.getDbServiceLocator().getService()).alternativeXsltSearchSQL(this.dbName, q.toString(), cq.toString(), xs.toString());
            log.info((Object)("Optained epr: " + epr));
            token.getEnv().setTransientAttribute("epr", (Object)epr);
            engine.complete(token, Arc.DEFAULT_ARC);
        }
        catch (Throwable e) {
            this.failed(engine, token, e);
        }
    }

    public String getDbName() {
        return this.dbName;
    }

    @Required
    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public ServiceLocator<DatabaseService> getDbServiceLocator() {
        return this.dbServiceLocator;
    }

    @Required
    public void setDbServiceLocator(ServiceLocator<DatabaseService> dbServiceLocator) {
        this.dbServiceLocator = dbServiceLocator;
    }

    public Resource getQuery() {
        return this.query;
    }

    @Required
    public void setQuery(Resource query) {
        this.query = query;
    }

    public Resource getCountQuery() {
        return this.countQuery;
    }

    @Required
    public void setCountQuery(Resource countQuery) {
        this.countQuery = countQuery;
    }

    public Resource getXslt() {
        return this.xslt;
    }

    @Required
    public void setXslt(Resource xslt) {
        this.xslt = xslt;
    }
}

