/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.actionmanager.hack;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.actionmanager.common.Operation;
import eu.dnetlib.actionmanager.common.Provenance;
import eu.dnetlib.actionmanager.hack.RequiredSet;
import eu.dnetlib.actionmanager.hbase.HBaseActionManagerCore;
import eu.dnetlib.enabling.resultset.WorkflowCountingResultSetFactory;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.workflow.AsyncJobNode;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.HTable;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Required;

public class StoreInfoPackageJobNode
extends AsyncJobNode {
    private static final Log log = LogFactory.getLog(StoreInfoPackageJobNode.class);
    private ResultSetClientFactory resultSetClientFactory;
    private HBaseActionManagerCore core;
    private String splitRuleId = "claimedMigration";
    private String defaultTrust;
    private WorkflowCountingResultSetFactory countingRSFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeAsync(Engine engine, NodeToken token) {
        SAXReader reader = new SAXReader();
        try {
            HTable table = this.getTable();
            try {
                W3CEndpointReference epr = (W3CEndpointReference)token.getEnv().getTransientAttribute("epr");
                for (String record : this.resultSetClientFactory.getClient(this.getCountingRSFactory().createCountingResultSet(epr, token))) {
                    Document doc = reader.read((Reader)new StringReader(record));
                    String id = doc.valueOf("//*[local-name()='objIdentifier']");
                    String user = doc.valueOf("//*[local-name()='user']");
                    String nsprefix = doc.valueOf("//*[local-name()='datasourceprefix']");
                    Enum set = null;
                    Provenance provenance = null;
                    Operation operation = Operation.INSERT;
                    Agent agent = null;
                    if (user != null && !user.trim().isEmpty()) {
                        agent = new Agent(user.trim(), user.trim(), Agent.AGENT_TYPE.human);
                        if (id.startsWith("crossref____::")) {
                            set = RequiredSet.userclaim_search_crossref;
                            provenance = Provenance.user_claim_doi;
                        } else if (id.startsWith("driver______::")) {
                            set = RequiredSet.userclaim_search_driver;
                            provenance = Provenance.user_claim_driver;
                        } else {
                            log.warn((Object)("I can't assign set and provenance for id " + id));
                            log.warn((Object)record);
                        }
                    } else {
                        log.warn((Object)("********* Missing user for record: " + id));
                    }
                    this.core.applyInfoPackageAction(this.splitRuleId, set.toString(), agent, operation, record, provenance, this.defaultTrust, nsprefix, table);
                }
                engine.complete(token, Arc.DEFAULT_ARC);
            }
            catch (Exception e) {
                log.error((Object)"Error storing EPR");
                this.failed(engine, token, e);
            }
            finally {
                table.flushCommits();
                table.close();
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error storing EPR");
            this.failed(engine, token, e);
        }
    }

    private HTable getTable() throws IOException {
        return new HTable(this.core.getHbaseClient().getConfig(), this.core.getHbaseClient().getTableName());
    }

    public ResultSetClientFactory getResultSetClientFactory() {
        return this.resultSetClientFactory;
    }

    @Required
    public void setResultSetClientFactory(ResultSetClientFactory resultSetClientFactory) {
        this.resultSetClientFactory = resultSetClientFactory;
    }

    public HBaseActionManagerCore getCore() {
        return this.core;
    }

    @Required
    public void setCore(HBaseActionManagerCore core) {
        this.core = core;
    }

    public String getSplitRuleId() {
        return this.splitRuleId;
    }

    @Required
    public void setSplitRuleId(String splitRuleId) {
        this.splitRuleId = splitRuleId;
    }

    public String getDefaultTrust() {
        return this.defaultTrust;
    }

    @Required
    public void setDefaultTrust(String defaultTrust) {
        this.defaultTrust = defaultTrust;
    }

    public WorkflowCountingResultSetFactory getCountingRSFactory() {
        return this.countingRSFactory;
    }

    @Required
    public void setCountingRSFactory(WorkflowCountingResultSetFactory countingRSFactory) {
        this.countingRSFactory = countingRSFactory;
    }
}

