/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.actionmanager.hbase;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.hash.Hashing;
import com.google.gson.Gson;
import com.google.protobuf.InvalidProtocolBufferException;
import eu.dnetlib.actionmanager.ActionManagerConstants;
import eu.dnetlib.actionmanager.rmi.ActionManagerException;
import eu.dnetlib.data.hadoop.config.ClusterName;
import eu.dnetlib.data.hadoop.config.ConfigurationEnumerator;
import eu.dnetlib.data.proto.OafProtos;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.util.Bytes;
import org.springframework.beans.factory.annotation.Required;

public class HBaseClient {
    private String tableName;
    @Resource
    private ConfigurationEnumerator configurationEnumerator;
    private Configuration config;
    private static final Log log = LogFactory.getLog(HBaseClient.class);
    private final Executor executor = Executors.newSingleThreadExecutor();
    private final Function<Result, Map<String, String>> transformRow = new Function<Result, Map<String, String>>(){

        public Map<String, String> apply(Result r) {
            HashMap map = Maps.newHashMap();
            map.put("rowId", Bytes.toString((byte[])r.getRow()));
            for (Map.Entry e1 : r.getMap().entrySet()) {
                String cf = Bytes.toString((byte[])((byte[])e1.getKey()));
                for (Map.Entry e2 : ((NavigableMap)e1.getValue()).entrySet()) {
                    byte[] bb = (byte[])((NavigableMap)e2.getValue()).get(Collections.max(((NavigableMap)e2.getValue()).keySet()));
                    String key = cf + ":" + Bytes.toString((byte[])((byte[])e2.getKey()));
                    String value = "";
                    try {
                        value = key.equals("target:content") ? OafProtos.Oaf.parseFrom((byte[])bb).toString() : Bytes.toString((byte[])bb);
                    }
                    catch (InvalidProtocolBufferException e) {
                        log.error((Object)"Problem parsing protobuf !!!");
                    }
                    map.put(key, value);
                }
            }
            return map;
        }
    };

    public void init() {
        this.performInit(false);
    }

    public void initWithEmptyTable() {
        this.performInit(true);
    }

    private void performInit(final boolean delete) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    log.info((Object)"Initializing Action Manager");
                    HBaseClient.this.loadConfiguration();
                    HBaseClient.this.prepareTable(delete);
                    log.info((Object)"ActionManager is ready");
                }
                catch (IOException e) {
                    log.error((Object)"Error initializing action manager", (Throwable)e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareTable(boolean delete) throws IOException {
        HBaseAdmin admin = new HBaseAdmin(this.config);
        try {
            if (delete && admin.tableExists(this.tableName)) {
                log.info((Object)("Deleting existing hbase table: " + this.tableName));
                admin.disableTable(this.tableName);
                admin.deleteTable(this.tableName);
            }
            if (!admin.tableExists(this.tableName)) {
                log.info((Object)("Creating missing hbase table: " + this.tableName));
                admin.createTable(new HTableDescriptor(this.tableName));
            }
            HTableDescriptor desc = admin.getTableDescriptor(Bytes.toBytes((String)this.getTableName()));
            HashSet currents = Sets.newHashSet();
            for (HColumnDescriptor hcd : desc.getColumnFamilies()) {
                currents.add(hcd.getNameAsString());
            }
            HashSet missing = Sets.newHashSet();
            for (ActionManagerConstants.COLUMN_FAMILIES cf : ActionManagerConstants.COLUMN_FAMILIES.values()) {
                if (currents.contains(cf.toString())) continue;
                missing.add(cf.toString());
            }
            if (!missing.isEmpty()) {
                if (admin.isTableEnabled(this.getTableName())) {
                    admin.disableTable(this.getTableName());
                }
                for (String column : missing) {
                    log.info((Object)("hbase table: '" + this.getTableName() + "', adding columnFamily: " + column));
                    admin.addColumn(this.getTableName(), new HColumnDescriptor(column));
                }
                admin.enableTable(this.getTableName());
            }
        }
        finally {
            admin.close();
        }
    }

    private void loadConfiguration() throws IOException {
        this.config = this.configurationEnumerator.get(ClusterName.DM);
        log.info((Object)this.config.toString());
    }

    public Configuration getConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(List<Put> puts) throws ActionManagerException {
        try {
            HTable table = new HTable(this.config, this.tableName);
            try {
                log.info((Object)("Adding " + puts.size() + " action(s) to " + this.tableName));
                table.put(puts);
            }
            finally {
                table.flushCommits();
                table.close();
            }
        }
        catch (IOException e) {
            throw new ActionManagerException((Throwable)e);
        }
    }

    public void write(List<Put> puts, HTable table) throws ActionManagerException {
        try {
            log.info((Object)("Adding " + puts.size() + " action(s) to " + this.tableName));
            table.put(puts);
        }
        catch (IOException e) {
            throw new ActionManagerException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(List<Delete> deletes) throws ActionManagerException {
        try {
            HTable table = new HTable(this.config, this.tableName);
            try {
                log.info((Object)("Deleting " + deletes.size() + " action(s) from " + this.tableName));
                table.delete(deletes);
            }
            finally {
                table.flushCommits();
                table.close();
            }
        }
        catch (IOException e) {
            throw new ActionManagerException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getRow(byte[] id) throws ActionManagerException {
        Map map;
        HTable table = new HTable(this.config, this.tableName);
        try {
            Result result = table.get(new Get(id));
            map = (Map)this.transformRow.apply((Object)result);
        }
        catch (Throwable throwable) {
            try {
                table.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new ActionManagerException((Throwable)e);
            }
        }
        table.close();
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, String>> retrieveRows(String prefix, String start, int limit) throws ActionManagerException {
        ArrayList list = Lists.newArrayList();
        try {
            HTable table = new HTable(this.config, this.tableName);
            try {
                PageFilter filter = prefix == null || prefix.isEmpty() ? new PageFilter((long)limit) : new FilterList(FilterList.Operator.MUST_PASS_ALL, new Filter[]{new PageFilter((long)limit), new PrefixFilter(Bytes.toBytes((String)prefix))});
                Scan scan = new Scan();
                if (start != null) {
                    scan.setStartRow(Bytes.toBytes((String)start));
                }
                scan.setFilter((Filter)filter);
                ResultScanner rs = table.getScanner(scan);
                try {
                    Iterator iter = Iterators.transform((Iterator)rs.iterator(), this.transformRow);
                    while (iter.hasNext()) {
                        list.add(iter.next());
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                table.close();
            }
        }
        catch (IOException e) {
            throw new ActionManagerException((Throwable)e);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> retrieveActionsByAgent(String agentId, int limit) throws ActionManagerException {
        ArrayList list = Lists.newArrayList();
        String prefix = ActionManagerConstants.ACTION_TYPE.pkg + "|" + Hashing.md5().hashString((CharSequence)agentId) + "|";
        try {
            HTable table = new HTable(this.config, this.tableName);
            try {
                FilterList filter = new FilterList(FilterList.Operator.MUST_PASS_ALL);
                filter.addFilter((Filter)new PageFilter((long)limit));
                filter.addFilter((Filter)new PrefixFilter(Bytes.toBytes((String)prefix)));
                Scan scan = new Scan();
                scan.setFilter((Filter)filter);
                ResultScanner rs = table.getScanner(scan);
                for (Result r : rs) {
                    HashMap map = Maps.newHashMap();
                    map.put("id", Bytes.toString((byte[])r.getRow()));
                    map.put("content", Bytes.toString((byte[])r.getValue(ActionManagerConstants.ACTION_COLFAMILY, Bytes.toBytes((String)ActionManagerConstants.ACTION_TYPE.pkg.toString()))));
                    list.add(new Gson().toJson((Object)map));
                }
            }
            finally {
                table.close();
            }
        }
        catch (IOException e) {
            throw new ActionManagerException((Throwable)e);
        }
        return list;
    }

    public String getTableName() {
        return this.tableName;
    }

    @Required
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }
}

