/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.actionmanager.wf;

import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.mapreduce.wf.SetupMapreduceJobNode;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.RunningJob;

public abstract class AbstractHbaseActionJobNode
extends SetupMapreduceJobNode {
    private static final Log log = LogFactory.getLog(AbstractHbaseActionJobNode.class);

    protected Properties prepareJob(NodeToken token) {
        Properties p = new Properties();
        p.setProperty("hbase.source.table", this.getSourceTable(token));
        p.setProperty("hbase.mapred.outputtable", this.getTargetTable(token));
        String set = token.getFullEnv().getAttribute("set");
        if (set != null) {
            p.setProperty("set", set);
        }
        return p;
    }

    protected abstract String getSourceTable(NodeToken var1);

    protected abstract String getTargetTable(NodeToken var1);

    protected void beforeCompleted(NodeToken token, RunningJob job) {
        Object callback = token.getFullEnv().getTransientAttribute("callbackCompleted");
        if (callback != null && callback instanceof Callable) {
            try {
                ((Callable)callback).call();
            }
            catch (Exception e) {
                log.error((Object)"Error executing callback");
            }
        }
    }

    protected void beforeFailed(NodeToken token, RunningJob job) {
        Object callback = token.getFullEnv().getTransientAttribute("callbackFailed");
        if (callback != null && callback instanceof Callable) {
            try {
                ((Callable)callback).call();
            }
            catch (Exception e) {
                log.error((Object)"Error executing callback");
            }
        }
    }
}

