<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:dri="http://www.driver-repository.eu/namespace/dri" xmlns:dr="http://www.driver-repository.eu/namespace/dr"
	xmlns:oaf="http://namespace.openaire.eu/oaf" xmlns:dc="http://purl.org/dc/elements/1.1/"
	xmlns:action="http://namespace.openaire.eu/action" xmlns:dnet="eu.dnetlib.miscutils.functional.xml.DnetXsltFunctions">

	
	<xsl:variable name="oldCollectedFromId" select="normalize-space(.//FIELD[@name='temp_collectedfromid']/ITEM)" />
	<xsl:variable name="tmpCollectedFromId">
		<xsl:choose>
			<xsl:when test="oldCollectedFromId = 'a35c057b-e732-44e2-a740-35e540dd0c58'">opendoar::162</xsl:when>
			<xsl:when test="oldCollectedFromId = 'dce34acf-e2fa-45ef-ba50-84a2742eb5bf'">opendoar::322</xsl:when>
			<xsl:when test="oldCollectedFromId = '83cf4d66-7c70-4835-887b-cf3e87db2faf'">opendoar::714</xsl:when>
			<xsl:when test="oldCollectedFromId = '64ea16ca-716e-49b6-99e9-059cbb52d18c'">opendoar::970</xsl:when>
			<xsl:when test="oldCollectedFromId = '6c2360ef-e891-4c3c-8031-53412dfd5965'">opendoar::1371</xsl:when>
			<xsl:when test="oldCollectedFromId = 'f06ae7a2-a5fb-4b14-ad1a-2f7011462303'">opendoar::2367</xsl:when>
			<xsl:when test="oldCollectedFromId = 'a8a73ca9-f34e-41eb-a20c-a06b703b1f6e'">opendoar::2336</xsl:when>
			<xsl:when test="oldCollectedFromId = '2d4b0cd7-84f5-4182-b598-0719423f37a4'">opendoar::1620</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$oldCollectedFromId" />
			</xsl:otherwise>	
		</xsl:choose>
	</xsl:variable>
	
	<xsl:variable name="collectedFromId" select="normalize-space($tmpCollectedFromId)" />
	<xsl:variable name="collectedFromName" select="normalize-space(.//FIELD[@name='temp_collectedfromname']/ITEM)" />
	
	<xsl:variable name="hostedById" select="normalize-space(.//FIELD[@name='temp_hostedbyid']/ITEM)" />
	<xsl:variable name="hostedByName" select="normalize-space(.//FIELD[@name='temp_hostedbyname']/ITEM)" />
	<xsl:variable name="createdFrom" select="normalize-space(.//FIELD[@name='temp_createdfrom'])" />


	<xsl:variable name="nsprefixTmp">
		<xsl:choose>
			<xsl:when test="starts-with($createdFrom, 'driver')">driver______</xsl:when>
			<xsl:when test="starts-with($createdFrom, 'doi')">crossref____</xsl:when>
			<xsl:when test="starts-with($createdFrom, 'isiWOS')">webcrawl____</xsl:when>
			
			<!-- When the production db will be fixed replace hostedById with collectedFromId -->
			<xsl:when test="$hostedById = 'opendoar::18'">od________18</xsl:when>
			<xsl:when test="$collectedFromId = 'opendoar::162'">od_______162</xsl:when>
			<xsl:when test="$collectedFromId = 'opendoar::206'">od_______206</xsl:when>
			<xsl:when test="$collectedFromId = 'opendoar::322'">od_______322</xsl:when>
			<xsl:when test="$collectedFromId = 'opendoar::714'">od_______714</xsl:when>
			<xsl:when test="$collectedFromId = 'opendoar::908'">od_______908</xsl:when>
			<xsl:when test="$collectedFromId = 'opendoar::970'">od_______970</xsl:when>
			<xsl:when test="$collectedFromId = 'opendoar::1175'">od______1175</xsl:when>
			<xsl:when test="$collectedFromId = 'opendoar::1371'">od______1371</xsl:when>
			<xsl:when test="$collectedFromId = 'opendoar::2367'">od______2367</xsl:when>
			<xsl:when test="$collectedFromId = 'opendoar::2336'">od______2336</xsl:when>
			<xsl:when test="$collectedFromId = 'opendoar::1620'">od______1620</xsl:when>
			<xsl:when test="$collectedFromId = '1256f046-bf1f-4afc-8b47-d0b147148b18'">unknown_____</xsl:when>
			<xsl:otherwise>unknown_____</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	
	<xsl:variable name="nsprefix" select="normalize-space($nsprefixTmp)" />

	<xsl:template match="//ROW">
		<record>
			<header>
				<dri:objIdentifier><xsl:value-of select="concat($nsprefix, '::', dnet:md5(./FIELD[@name='dri_objidentifier']))" /></dri:objIdentifier>
				<oaf:datasourceprefix><xsl:value-of select="$nsprefix" /></oaf:datasourceprefix>
				<xsl:for-each select="./FIELD[starts-with(@name, 'action_')]">
					<xsl:variable name="fieldName" select="substring-after(@name, 'action_')" />
					<xsl:element name="action:{$fieldName}">
						<xsl:value-of select="normalize-space(.)" />
					</xsl:element>
				</xsl:for-each>
				<xsl:variable name="dateofcollection">
					<xsl:choose>
						<xsl:when test="string-length(normalize-space(./FIELD[@name = 'action_date_of_creation'])) &gt; 0">
							<xsl:value-of select="./FIELD[@name = 'action_date_of_creation']"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="./FIELD[@name = 'oaf_storagedate']"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<dr:dateOfCollection><xsl:value-of select="$dateofcollection"></xsl:value-of></dr:dateOfCollection>
			</header>
			<metadata>
				<xsl:for-each select="./FIELD[@name != 'dri_objidentifier' and not(starts-with(@name, 'action_')) and not(starts-with(@name, 'temp_'))]">
					<xsl:variable name="fieldNS" select="substring-before(@name, '_')" />
					<xsl:variable name="fieldName" select="substring-after(@name, '_')" />

					<xsl:choose>
						<xsl:when test="count(./ITEM)=0">
							<xsl:if test="not(@isNull) or @isNull != 'true'">
								<xsl:element name="{$fieldNS}:{$fieldName}">
									<xsl:value-of select="normalize-space(.)" />
								</xsl:element>
							</xsl:if>
						</xsl:when>
						<xsl:otherwise>
						<xsl:for-each select="./ITEM">
								<xsl:sort select="normalize-space(.)"/>
								<xsl:variable name="val" select="normalize-space(.)" />
								<xsl:element name="{$fieldNS}:{$fieldName}">
									<xsl:choose>
										<xsl:when test="contains($val,'§§§')">
											<xsl:value-of select="normalize-space(substring-after($val,'§§§'))" />
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="$val" />
										</xsl:otherwise>
									</xsl:choose>
								</xsl:element>
							</xsl:for-each>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:for-each>
				
				<xsl:for-each select=".//FIELD[@name='temp_projectid']/ITEM">
					<oaf:projectid><xsl:value-of select="concat('corda_______::', normalize-space(.))" /></oaf:projectid>
				</xsl:for-each>
								
				<!-- Probably also arxiv and pubmed identifiers should be added -->
				<xsl:if test="starts-with($createdFrom, 'doi')">
					<oaf:identifier identifierType="doi"><xsl:value-of select="$createdFrom" /></oaf:identifier>
				</xsl:if>
				
				<xsl:choose>
					<xsl:when test="starts-with($createdFrom, 'driver')">
						<oaf:collectedFrom name="Digital Repository Infrastructure Vision for European Research" id="openaire____::driver"/>
					</xsl:when>
					<xsl:when test="starts-with($createdFrom, 'doi')">
						<oaf:collectedFrom name="Crossref" id="openaire____::crossref"/>
					</xsl:when>
					<xsl:when test="starts-with($collectedFromId, 'opendoar::')">
						<oaf:collectedFrom name="{$collectedFromName}" id="opendoar____::{substring-after($hostedById, 'opendoar::')}" />
					</xsl:when>
					<xsl:when test="string-length($collectedFromId) = 36">
						<oaf:collectedFrom name="{$collectedFromName}" id="openaire____::{$collectedFromId}" />
					</xsl:when>
					<xsl:when test="$hostedById = 'openaire::WOS'">
						<oaf:collectedFrom name="Web Crawl" id="openaire____::webcrawl" />
					</xsl:when>					
					<xsl:otherwise>
						<oaf:collectedFrom />
					</xsl:otherwise>
				</xsl:choose>

				<xsl:choose>
					<xsl:when test="$hostedById = 'openaire::WOS'">
						<oaf:hostedBy name="Web Crawl" id="openaire____::webcrawl" />
					</xsl:when>
					<xsl:when test="starts-with($hostedById, 'opendoar::')">
						<oaf:hostedBy name="{$hostedByName}" id="opendoar____::{substring-after($hostedById, 'opendoar::')}" />
					</xsl:when>
					<xsl:when test="$hostedById = 'cdf921f9-0b9f-43c9-bd4c-7c4955f273ca'">
						<oaf:hostedBy name="arXiv.org e-Print Archive" id="opendoar____::18" />
					</xsl:when>					
					<xsl:when test="string-length($hostedById) = 36">
						<oaf:hostedBy name="{$hostedByName}" id="openaire____::{$hostedById}" />
					</xsl:when>
					<xsl:otherwise>
						<oaf:hostedBy />
					</xsl:otherwise>
				</xsl:choose>
			</metadata>
		</record>
	</xsl:template>

</xsl:stylesheet>

