package eu.dnetlib.actionmanager.hbase;

import java.util.List;
import java.util.Map;

import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.util.Bytes;
import org.springframework.beans.factory.annotation.Required;

import com.google.common.collect.Lists;

import eu.dnetlib.actionmanager.actions.ActionFactory;
import eu.dnetlib.actionmanager.actions.XsltInfoPackageAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.actionmanager.common.Operation;
import eu.dnetlib.actionmanager.common.Provenance;
import eu.dnetlib.actionmanager.is.ISClient;
import eu.dnetlib.actionmanager.rmi.ActionManagerException;
import eu.dnetlib.actionmanager.set.ActionManagerSet;

public class HBaseActionManagerCore {

	private ActionFactory actionFactory;

	private HBaseClient hbaseClient;

	private ISClient informationServiceClient;

	/*
	 * public void insertOrUpdateAtomicAction(AtomicAction action, String provenance, String trust) throws
	 * ActionManagerException { hbaseClient.write(action.asPutOperations(null, provenance, trust, null)); }
	 * 
	 * public void insertOrUpdateAtomicActions(List<AtomicAction> actions, String provenance, String trust) throws
	 * ActionManagerException { for (AtomicAction action : actions) { insertOrUpdateAtomicAction(action, provenance,
	 * trust); } }
	 */

	public int applyInfoPackageAction(
			String splitRuleId,
			String set,
			Agent agent,
			Operation operation,
			String infoPackage,
			Provenance provenance,
			String trust,
			String nsprefix) throws ActionManagerException {

		if (informationServiceClient.existsSet(set)) {
			XsltInfoPackageAction action = actionFactory.generateInfoPackageAction(splitRuleId, set, agent, operation, infoPackage);
			List<Put> puts = action.asPutOperations(null, provenance, trust, nsprefix);
			hbaseClient.write(puts);
			return puts.size();
		} else {
			throw new ActionManagerException("Missing set " + set);
		}
	}
	
	public int applyInfoPackageAction(			
			String splitRuleId,
			String set,
			Agent agent,
			Operation operation,
			String infoPackage,
			Provenance provenance,
			String trust,
			String nsprefix,
			HTable table) throws ActionManagerException {
		if (informationServiceClient.existsSet(set)) {
			XsltInfoPackageAction action = actionFactory.generateInfoPackageAction(splitRuleId, set, agent, operation, infoPackage);
			List<Put> puts = action.asPutOperations(null, provenance, trust, nsprefix);
			hbaseClient.write(puts, table);
			return puts.size();
		} else {
			throw new ActionManagerException("Missing set " + set);
		}
		
	}

	public void deleteInfoPackageAction(String id) throws ActionManagerException {
		Map<String, String> row = hbaseClient.getRow(Bytes.toBytes(id));
		List<Delete> deletes = Lists.newArrayList();
		for (String key : row.keySet()) {
			if (key.startsWith("rel:")) {
				deletes.add(new Delete(Bytes.toBytes(key.substring(4))));
			}
		}
		deletes.add(new Delete(Bytes.toBytes(id)));
		hbaseClient.delete(deletes);
	}

	public ActionFactory getActionFactory() {
		return actionFactory;
	}

	@Required
	public void setActionFactory(ActionFactory actionFactory) {
		this.actionFactory = actionFactory;
	}

	public HBaseClient getHbaseClient() {
		return hbaseClient;
	}

	@Required
	public void setHbaseClient(HBaseClient hbaseClient) {
		this.hbaseClient = hbaseClient;
	}

	public List<ActionManagerSet> listAvailableSets() {
		return informationServiceClient.listSets();
	}

	public ISClient getInformationServiceClient() {
		return informationServiceClient;
	}

	@Required
	public void setInformationServiceClient(ISClient informationServiceClient) {
		this.informationServiceClient = informationServiceClient;
	}

}
