/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.actionmanager.blackboard;

import eu.dnetlib.actionmanager.blackboard.AbstractActionManagerAction;
import eu.dnetlib.actionmanager.blackboard.ActionManagerActions;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.actionmanager.common.Operation;
import eu.dnetlib.actionmanager.common.Provenance;
import eu.dnetlib.actionmanager.rmi.ActionManagerException;
import eu.dnetlib.enabling.resultset.client.IterableResultSetClient;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerAction;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import javax.annotation.Resource;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FeedActionManagerAction
extends AbstractActionManagerAction
implements BlackboardServerAction<ActionManagerActions> {
    private static final Log log = LogFactory.getLog(FeedActionManagerAction.class);
    @Resource
    private ResultSetClientFactory resultSetClientFactory;

    public void execute(BlackboardServerHandler handler, BlackboardJob job) {
        log.debug((Object)("Inside execute" + this.getClass().getSimpleName()));
        String epr = (String)job.getParameters().get("epr");
        String ruleId = (String)job.getParameters().get("ruleId");
        String set = (String)job.getParameters().get("set");
        Provenance provenance = Provenance.convert((String)((String)job.getParameters().get("provenance")));
        String trust = (String)job.getParameters().get("trust");
        String nsprefix = (String)job.getParameters().get("nsprefix");
        String agentID = (String)job.getParameters().get("agentId");
        String agentName = (String)job.getParameters().get("agentName");
        String agentType = (String)job.getParameters().get("agentType");
        int n = 0;
        try {
            n = this.feed(epr, ruleId, set, provenance, trust, nsprefix, agentID, agentName, agentType);
        }
        catch (ActionManagerException e) {
            handler.failed(job, (Throwable)e);
            return;
        }
        log.debug((Object)("Actions added: " + n));
        handler.done(job);
    }

    private int feed(String epr, String ruleId, String set, Provenance provenance, String trust, String nsprefix, String agentID, String agentName, String agentType) throws ActionManagerException {
        String decodeEPR = new String(Base64.decodeBase64((String)epr));
        IterableResultSetClient records = this.resultSetClientFactory.getClient(decodeEPR);
        int n = 0;
        Agent agent = new Agent();
        agent.setId(agentID);
        agent.setName(agentName);
        agent.setType(Agent.AGENT_TYPE.valueOf((String)agentType));
        for (String infoPackage : records) {
            if (infoPackage == null) continue;
            n += this.core.applyInfoPackageAction(ruleId, set, agent, Operation.INSERT, infoPackage, provenance, trust, nsprefix);
        }
        return n;
    }
}

