/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.actionmanager.inspector;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import eu.dnetlib.actionmanager.ActionManagerConstants;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.actionmanager.common.Operation;
import eu.dnetlib.actionmanager.common.Provenance;
import eu.dnetlib.actionmanager.hbase.HBaseActionManagerCore;
import eu.dnetlib.actionmanager.set.ActionManagerSet;
import eu.dnetlib.actionmanager.wf.ActionManagerWorkflowLauncher;
import eu.dnetlib.enabling.inspector.AbstractInspectorController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ActionManagerController
extends AbstractInspectorController {
    private static final int DEFAULT_PAGE_SIZE = 10;
    @Resource
    private HBaseActionManagerCore core;
    @Resource
    private ActionManagerWorkflowLauncher actionManagerWorkflowLauncher;

    @ModelAttribute(value="types")
    public ActionManagerConstants.ACTION_TYPE[] listActionTypes() {
        return ActionManagerConstants.ACTION_TYPE.values();
    }

    @ModelAttribute(value="provenances")
    public Provenance[] listProvenances() {
        return Provenance.values();
    }

    @ModelAttribute(value="sets")
    public List<ActionManagerSet> listSets() {
        return this.core.listAvailableSets();
    }

    @RequestMapping(value={"/inspector/actions/listActions.do"})
    public String listActions(ModelMap map, @RequestParam(value="type", required=false) String stype, @RequestParam(value="start", required=false) String start) throws Exception {
        String template;
        ActionManagerConstants.ACTION_TYPE type = stype == null ? ActionManagerConstants.ACTION_TYPE.all : ActionManagerConstants.ACTION_TYPE.valueOf((String)stype);
        String prefix = type == ActionManagerConstants.ACTION_TYPE.all ? null : type + "|";
        map.addAttribute("type", (Object)type);
        List<Map<String, String>> actions = this.core.getHbaseClient().retrieveRows(prefix, start, 11);
        int size = actions.size();
        if (size > 10) {
            map.addAttribute("next", (Object)actions.remove(size - 1).get("rowId"));
        }
        map.addAttribute("actions", (Object)Lists.transform(actions, (Function)new Function<Map<String, String>, Map<String, Object>>(){

            public Map<String, Object> apply(Map<String, String> map) {
                return ActionManagerController.this.formatAction(map);
            }
        }));
        switch (type) {
            case aac: {
                template = "listAtomicActions";
                break;
            }
            case pkg: {
                template = "listInfoPackages";
                break;
            }
            default: {
                template = "listAll";
            }
        }
        return "inspector/actions/" + template;
    }

    private Map<String, Object> formatAction(Map<String, String> map) {
        HashMap res = Maps.newHashMap();
        for (String key : map.keySet()) {
            if (key.equals("rowId")) {
                res.put("rowId", map.get(key));
                continue;
            }
            if (key.startsWith("date:")) {
                res.put("date", map.get(key));
                continue;
            }
            if (key.startsWith("set:")) {
                res.put("set", map.get(key));
                continue;
            }
            if (key.startsWith("operation:")) {
                res.put("operation", map.get(key));
                continue;
            }
            if (key.endsWith(":" + ActionManagerConstants.ACTION_TYPE.pkg)) {
                res.put("infoPackage", map.get(key).replaceAll("<", "&lt;").replaceAll(">", "&gt;"));
                continue;
            }
            if (key.startsWith("rel:")) {
                String nk = map.get(key).trim();
                if (!res.containsKey(nk)) {
                    res.put(nk, new ArrayList());
                }
                ((List)res.get(nk)).add(key.substring(4));
                continue;
            }
            if (key.startsWith("target:")) {
                res.put(key.replaceAll(":", "_"), map.get(key));
                continue;
            }
            res.put(key, map.get(key));
        }
        return res;
    }

    @RequestMapping(value={"/inspector/actions/registerInfoPackage.do"})
    public void registerInfoPackage(ModelMap map, @RequestParam(value="ruleId", required=false) String ruleId, @RequestParam(value="set", required=false) String set, @RequestParam(value="infoPackage", required=false) String infoPackage, @RequestParam(value="provenance", required=false) String provenance, @RequestParam(value="trust", required=false) String trust, @RequestParam(value="nsprefix", required=false) String nsprefix) throws Exception {
        if (!(ruleId == null || ruleId.isEmpty() || set == null || set.isEmpty() || infoPackage == null || infoPackage.isEmpty() || trust == null || trust.isEmpty() || provenance == null || provenance.isEmpty() || nsprefix == null || nsprefix.isEmpty() || !this.core.getActionFactory().getXslts().containsKey(ruleId))) {
            Agent agent = new Agent();
            agent.setId("inspector");
            agent.setName("inspector");
            agent.setType(Agent.AGENT_TYPE.human);
            int n = this.core.applyInfoPackageAction(ruleId, set, agent, Operation.INSERT, infoPackage, Provenance.convert((String)provenance), trust, nsprefix);
            map.addAttribute("message", (Object)("1 infoPackageAction + " + (n - 1) + " atomicAction(s) registered"));
        }
        map.addAttribute("rules", this.core.getActionFactory().getXslts().keySet());
        map.addAttribute("ruleId", (Object)ruleId);
        map.addAttribute("set", (Object)set);
        map.addAttribute("infoPackage", (Object)infoPackage);
        map.addAttribute("trust", (Object)trust);
        map.addAttribute("nsprefix", (Object)nsprefix);
    }

    @RequestMapping(value={"/inspector/actions/deleteInfoPackage.do"})
    public String deleteInfoPackage(ModelMap map, @RequestParam(value="id", required=false) String id) throws Exception {
        this.core.deleteInfoPackageAction(id);
        return "redirect:listActions.do?type=" + ActionManagerConstants.ACTION_TYPE.pkg;
    }

    @RequestMapping(value={"/inspector/actions/bulkdelete.do"})
    public void clear(ModelMap map, @RequestParam(value="set", required=false) String set) throws Exception {
        map.addAttribute("allSets", (Object)"__ALL__");
        if (set != null && !set.isEmpty()) {
            this.actionManagerWorkflowLauncher.executeDelete(set, null, null);
            map.addAttribute("message", (Object)"Workflow started !!!");
        }
    }

    @RequestMapping(value={"/inspector/actions/commit.do"})
    public void commit(ModelMap map, @RequestParam(value="set", required=false) String set) throws Exception {
        map.addAttribute("allSets", (Object)"__ALL__");
        if (set != null && !set.isEmpty()) {
            this.actionManagerWorkflowLauncher.executeCommit(set, null, null);
            map.addAttribute("message", (Object)"Workflow started !!!");
        }
    }

    @RequestMapping(value={"/inspector/actions/createSet.do"})
    public void createSet(ModelMap map, @RequestParam(value="id", required=false) String id, @RequestParam(value="name", required=false) String name) throws Exception {
        if (id != null && name != null && !id.isEmpty() && !name.isEmpty()) {
            this.core.getInformationServiceClient().registerSetProfile(new ActionManagerSet(id, name));
        }
        map.addAttribute("sets", this.core.listAvailableSets());
    }
}

