/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.actionmanager.hbase;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import eu.dnetlib.actionmanager.hbase.HBaseBlackboardJobListener;
import eu.dnetlib.actionmanager.hbase.HBaseCallback;
import eu.dnetlib.actionmanager.is.ISClient;
import eu.dnetlib.actionmanager.rmi.ActionManagerException;
import eu.dnetlib.data.hadoop.config.ClusterName;
import eu.dnetlib.data.hadoop.rmi.HadoopBlackboardActions;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.enabling.tools.blackboard.BlackboardClientHandler;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJobListener;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJobRegistry;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class HBaseJobLauncher {
    private static final Log log = LogFactory.getLog(HBaseJobLauncher.class);
    public static final String ALL_SETS = "__ALL__";
    private final Executor executor = Executors.newCachedThreadPool();
    @Resource(name="lookupLocator")
    private ServiceLocator<ISLookUpService> lookupLocator;
    private ISClient infomationServiceClient;
    @Resource
    private BlackboardClientHandler blackboardClientHandler;
    @Resource
    private BlackboardJobRegistry jobRegistry;
    private String actionTable;
    private String dataTable;

    public void executeGarbageJob(HBaseCallback callback) throws ActionManagerException {
        log.info((Object)"Starting clean garbage m/r job");
        Set<String> rawSets = this.infomationServiceClient.listValidRawSets();
        this.execute("garbageActionsJob", rawSets, this.actionTable, this.actionTable, callback);
    }

    public void executePromoteJob(String set, HBaseCallback callback) throws ActionManagerException {
        log.info((Object)("Starting commit m/r job; set=" + set));
        HashSet rawSets = Sets.newHashSet();
        if (set == null || set.equals(ALL_SETS)) {
            rawSets.addAll(this.infomationServiceClient.listValidRawSets());
        } else if (this.infomationServiceClient.existsSet(set)) {
            rawSets.add(this.infomationServiceClient.geLatestRawSet(set).getId());
        } else {
            log.error((Object)("Invalid set " + set));
            throw new ActionManagerException("Invalid set " + set);
        }
        this.execute("promoteActionsJob", rawSets, this.actionTable, this.dataTable, callback);
    }

    private void execute(final String jobName, final Set<String> rawSets, final String inputTable, final String outputTable, final HBaseCallback callback) throws ActionManagerException {
        if (rawSets == null || rawSets.isEmpty()) {
            throw new ActionManagerException("Missing rawsets");
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    String serviceId = HBaseJobLauncher.this.findHadoopServiceProfileID();
                    BlackboardJob bbJob = HBaseJobLauncher.this.blackboardClientHandler.newJob(serviceId);
                    String rawsets = Joiner.on((String)",").skipNulls().join((Iterable)rawSets);
                    log.info((Object)("promoting rawsets: " + rawsets));
                    bbJob.setAction(HadoopBlackboardActions.SUBMIT_MAPREDUCE_JOB.toString());
                    bbJob.getParameters().put("job.name", jobName);
                    bbJob.getParameters().put("cluster", ClusterName.DM.toString());
                    bbJob.getParameters().put("latestRawSets", rawsets);
                    bbJob.getParameters().put("hbase.mapred.inputtable", inputTable);
                    bbJob.getParameters().put("hbase.mapreduce.inputtable", inputTable);
                    bbJob.getParameters().put("hbase.mapred.outputtable", outputTable);
                    bbJob.getParameters().put("hbase.mapreduce.outputtable", outputTable);
                    HBaseJobLauncher.this.jobRegistry.registerJobListener(bbJob, (BlackboardJobListener)new HBaseBlackboardJobListener(callback));
                    HBaseJobLauncher.this.blackboardClientHandler.assign(bbJob);
                }
                catch (Exception e) {
                    log.error((Object)("Error launching m/r job: " + jobName), (Throwable)e);
                    throw new RuntimeException("Error launching m/r job: " + jobName, e);
                }
            }
        });
    }

    private String findHadoopServiceProfileID() throws Exception {
        return ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery("collection('/db/DRIVER/ServiceResources/HadoopServiceResourceType')//RESOURCE_IDENTIFIER/@value/string()");
    }

    public String getActionTable() {
        return this.actionTable;
    }

    @Required
    public void setActionTable(String actionTable) {
        this.actionTable = actionTable;
    }

    public String getDataTable() {
        return this.dataTable;
    }

    @Required
    public void setDataTable(String dataTable) {
        this.dataTable = dataTable;
    }

    public ISClient getInfomationServiceClient() {
        return this.infomationServiceClient;
    }

    @Required
    public void setInfomationServiceClient(ISClient infomationServiceClient) {
        this.infomationServiceClient = infomationServiceClient;
    }
}

