package eu.dnetlib.actionmanager.hbase;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import eu.dnetlib.enabling.tools.blackboard.AbstractBlackboardJobListener;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;

public class HBaseBlackboardJobListener extends AbstractBlackboardJobListener {

	private static final Log log = LogFactory.getLog(HBaseBlackboardJobListener.class);

	private HBaseCallback callback;

	public HBaseBlackboardJobListener(final HBaseCallback callback) {
		super();
		this.callback = callback;
	}

	@Override
	protected void onDone(final BlackboardJob job) {
		try {
			if (callback != null) {
				callback.onDone();
			}
		} catch (Exception e) {
			log.error("fail to run a callback function");
		}
	}

	@Override
	protected void onFailed(final BlackboardJob job) {
		try {
			if (callback != null) {
				callback.onFailed();
			}
		} catch (Exception e) {
			log.error("fail to run a callback function");
		}
	}
}
