package eu.dnetlib.actionmanager.blackboard;

import eu.dnetlib.actionmanager.hbase.HBaseCallback;
import eu.dnetlib.actionmanager.rmi.ActionManagerException;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerAction;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;

public class GarbageActionManagerAction extends AbstractActionManagerAction implements BlackboardServerAction<ActionManagerActions> {

	// <MESSAGE id="bb-1234" date="2012-11-06T15:10:56+01:00">
	// <ACTION>DELETE</ACTION>
	// <PARAMETER name="set" value=""/>
	// <ACTION_STATUS>ASSIGNED</ACTION_STATUS>
	// </MESSAGE>

	@Override
	public void execute(final BlackboardServerHandler handler, final BlackboardJob job) {

		try {
			getHbaseJobLauncher().executeGarbageJob(new HBaseCallback() {

				@Override
				public void onDone() {
					handler.done(job);
				}

				@Override
				public void onFailed() {
					handler.failed(job, new ActionManagerException("MSRO Workwlow is failed"));
				}

			});
		} catch (Exception e) {
			handler.failed(job, e);
		}
	}
}
