package eu.dnetlib.actionmanager.blackboard;

import eu.dnetlib.actionmanager.hbase.HBaseCallback;
import eu.dnetlib.actionmanager.hbase.HBaseJobLauncher;
import eu.dnetlib.actionmanager.rmi.ActionManagerException;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerAction;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;

public class PromoteActionManagerAction extends AbstractActionManagerAction implements BlackboardServerAction<ActionManagerActions> {

	@Override
	public void execute(final BlackboardServerHandler handler, final BlackboardJob job) {

		String set = job.getParameters().get("set");
		if ((set == null) || set.isEmpty()) {
			set = HBaseJobLauncher.ALL_SETS;
		}

		try {
			getHbaseJobLauncher().executePromoteJob(set, new HBaseCallback() {

				@Override
				public void onDone() {
					handler.done(job);
				}

				@Override
				public void onFailed() {
					handler.failed(job, new ActionManagerException("MSRO Workwlow is failed"));
				}

			});
		} catch (Exception e) {
			handler.failed(job, e);
		}

	}
}
