package eu.dnetlib.actionmanager;

import java.util.List;

import javax.jws.WebParam;

import org.springframework.beans.factory.annotation.Required;

import eu.dnetlib.actionmanager.actions.XsltInfoPackageAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.actionmanager.common.Operation;
import eu.dnetlib.actionmanager.common.Provenance;
import eu.dnetlib.actionmanager.hbase.HBaseActionManagerCore;
import eu.dnetlib.actionmanager.rmi.ActionManagerException;
import eu.dnetlib.actionmanager.rmi.ActionManagerService;
import eu.dnetlib.actionmanager.set.ActionManagerSet;
import eu.dnetlib.enabling.tools.AbstractBaseService;
import eu.dnetlib.enabling.tools.blackboard.NotificationHandler;

public class ActionManagerServiceImpl extends AbstractBaseService implements ActionManagerService {

	private HBaseActionManagerCore core;

	private NotificationHandler notificationHandler;

	@Override
	public String createSet(@WebParam(name = "set") final ActionManagerSet set) throws ActionManagerException {
		return core.getInformationServiceClient().registerSetProfile(set);
	}

	@Override
	public boolean deleteSet(@WebParam(name = "set") final String setId) throws ActionManagerException {
		return core.getInformationServiceClient().deleteSetProfile(setId);
	}

	@Override
	public List<ActionManagerSet> ListSets() throws ActionManagerException {
		return core.listAvailableSets();
	}

	@Override
	public String createAction(final String splitRuleId,
			final String set,
			final Agent agent,
			final Operation operation,
			final String infoPackage,
			final Provenance provenance,
			final String trust,
			final String nsprefix) throws ActionManagerException {

		final XsltInfoPackageAction action = core.applyInfoPackageAction(splitRuleId, set, agent, operation, infoPackage, provenance, trust, nsprefix);
		return action.getRowKey();
	}

	@Override
	public String updateAction(final String actionId,
			final String splitRuleId,
			final String set,
			final Agent agent,
			final Operation operation,
			final String infoPackage,
			final Provenance provenance,
			final String trust,
			final String nsprefix) throws ActionManagerException {

		core.deleteInfoPackageAction(actionId);

		final XsltInfoPackageAction action = core.applyInfoPackageAction(splitRuleId, set, agent, operation, infoPackage, provenance, trust, nsprefix);

		return action.getRowKey();
	}

	@Override
	public boolean deleteAction(final String actionId) throws ActionManagerException {
		core.deleteInfoPackageAction(actionId);
		return true;
	}

	@Override
	public List<String> getActionsByAgent(final String agentId, final int limit) throws ActionManagerException {
		return core.getHbaseClient().retrieveActionsByAgent(agentId, limit);
	}

	@Override
	public void notify(final String subscriptionId, final String topic, final String isId, final String message) {
		notificationHandler.notified(subscriptionId, topic, isId, message);
	}

	public HBaseActionManagerCore getCore() {
		return core;
	}

	public void setCore(final HBaseActionManagerCore core) {
		this.core = core;
	}

	public NotificationHandler getNotificationHandler() {
		return notificationHandler;
	}

	@Required
	public void setNotificationHandler(final NotificationHandler notificationHandler) {
		this.notificationHandler = notificationHandler;
	}

}
