package eu.dnetlib.actionmanager.blackboard;

import javax.annotation.Resource;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.actionmanager.common.Operation;
import eu.dnetlib.actionmanager.common.Provenance;
import eu.dnetlib.actionmanager.rmi.ActionManagerException;
import eu.dnetlib.actionmanager.set.RawSet;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerAction;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import eu.dnetlib.miscutils.datetime.DateUtils;

// TODO: Auto-generated Javadoc
/**
 * The Class FeedActionManagerAction.
 */
public class FeedActionManagerAction extends AbstractActionManagerAction implements BlackboardServerAction<ActionManagerActions> {

	/** The Constant log. */
	private static final Log log = LogFactory.getLog(FeedActionManagerAction.class);

	/** The result set client factory. */
	@Resource
	private ResultSetClientFactory resultSetClientFactory;

	/**
	 * input parameters: epr: result-set end point reference containg the set of package info ruleId: one of the rules available to apply
	 * set: the destination set for the current info-packages provenance: the source of the info-packages fed trust: trust level nsprefix:
	 * namespace prefix agentID agentType.
	 * 
	 * @param handler
	 *            the handler
	 * @param job
	 *            the job
	 * @throws ActionManagerException
	 */
	@Override
	public void execute(final BlackboardServerHandler handler, final BlackboardJob job) throws ActionManagerException {
		log.debug("Inside execute" + this.getClass().getSimpleName());

		String epr = job.getParameters().get("epr");
		String ruleId = job.getParameters().get("ruleId");
		String set = job.getParameters().get("set");
		Provenance provenance = Provenance.convert(job.getParameters().get("provenance"));
		String trust = job.getParameters().get("trust");
		String nsprefix = job.getParameters().get("nsprefix");
		String agentID = job.getParameters().get("agentId");
		String agentName = job.getParameters().get("agentName");
		String agentType = job.getParameters().get("agentType");
		String mode = job.getParameters().get("mode");

		RawSet rawSet = null;
		if ((mode != null) && mode.equalsIgnoreCase("REFRESH")) {
			rawSet = RawSet.newInstance();
		} else if (core.getInformationServiceClient().existsSet(set)) {
			rawSet = core.getInformationServiceClient().geLatestRawSet(set);
		} else {
			throw new ActionManagerException("Missing set " + set);
		}

		int n = 0;
		try {
			n = feed(epr, ruleId, set, rawSet, provenance, trust, nsprefix, agentID, agentName, agentType);

			if ((mode != null) && mode.equalsIgnoreCase("REFRESH")) {
				rawSet.setLastUpdate(DateUtils.now_ISO8601());
				core.getInformationServiceClient().addLatestRawSet(set, rawSet);
			} else {
				core.getInformationServiceClient().updateLastUpdate(rawSet.getId());
			}

		} catch (ActionManagerException e) {
			handler.failed(job, e);
			return;
		}

		log.debug("Actions added: " + n);

		job.getParameters().put("n_actions", Integer.toString(n));

		handler.done(job);
	}

	/**
	 * Feed.
	 * 
	 * @param epr
	 *            the epr
	 * @param ruleId
	 *            the rule id
	 * @param set
	 *            the set
	 * @param provenance
	 *            the provenance
	 * @param trust
	 *            the trust
	 * @param nsprefix
	 *            the nsprefix
	 * @param agentID
	 *            the agent id
	 * @param agentType
	 *            the agent type
	 * @return the int
	 * @throws ActionManagerException
	 *             the action manager exception
	 */
	private int feed(final String epr,
			final String ruleId,
			final String set,
			final RawSet rawSet,
			final Provenance provenance,
			final String trust,
			final String nsprefix,
			final String agentID,
			final String agentName,
			final String agentType

	) throws ActionManagerException {
		String decodeEPR = new String(Base64.decodeBase64(epr));

		final Iterable<String> records = resultSetClientFactory.getClient(decodeEPR);
		int n = 0;
		Agent agent = new Agent();
		agent.setId(agentID);
		agent.setName(agentName);
		agent.setType(Agent.AGENT_TYPE.valueOf(agentType));
		for (String infoPackage : records) {
			if (infoPackage != null) {
				core.bulkApplyInfoPackageAction(ruleId, rawSet, agent, Operation.INSERT, infoPackage, provenance, trust, nsprefix);
			}
		}

		return n;
	}
}
