/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.actionmanager;

import eu.dnetlib.actionmanager.actions.XsltInfoPackageAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.actionmanager.common.Operation;
import eu.dnetlib.actionmanager.common.Provenance;
import eu.dnetlib.actionmanager.hbase.HBaseActionManagerCore;
import eu.dnetlib.actionmanager.rmi.ActionManagerException;
import eu.dnetlib.actionmanager.rmi.ActionManagerService;
import eu.dnetlib.actionmanager.set.ActionManagerSet;
import eu.dnetlib.enabling.tools.AbstractBaseService;
import eu.dnetlib.enabling.tools.blackboard.NotificationHandler;
import java.util.List;
import javax.jws.WebParam;
import org.springframework.beans.factory.annotation.Required;

public class ActionManagerServiceImpl
extends AbstractBaseService
implements ActionManagerService {
    private HBaseActionManagerCore core;
    private NotificationHandler notificationHandler;

    public String createSet(@WebParam(name="set") ActionManagerSet set) throws ActionManagerException {
        return this.core.getInformationServiceClient().registerSetProfile(set);
    }

    public boolean deleteSet(@WebParam(name="set") String setId) throws ActionManagerException {
        return this.core.getInformationServiceClient().deleteSetProfile(setId);
    }

    public List<ActionManagerSet> ListSets() throws ActionManagerException {
        return this.core.listAvailableSets();
    }

    public String createAction(String splitRuleId, String set, Agent agent, Operation operation, String infoPackage, Provenance provenance, String trust, String nsprefix) throws ActionManagerException {
        XsltInfoPackageAction action = this.core.applyInfoPackageAction(splitRuleId, set, agent, operation, infoPackage, provenance, trust, nsprefix);
        return action.getRowKey();
    }

    public String updateAction(String actionId, String splitRuleId, String set, Agent agent, Operation operation, String infoPackage, Provenance provenance, String trust, String nsprefix) throws ActionManagerException {
        this.core.deleteInfoPackageAction(actionId);
        XsltInfoPackageAction action = this.core.applyInfoPackageAction(splitRuleId, set, agent, operation, infoPackage, provenance, trust, nsprefix);
        return action.getRowKey();
    }

    public boolean deleteAction(String actionId) throws ActionManagerException {
        this.core.deleteInfoPackageAction(actionId);
        return true;
    }

    public List<String> getActionsByAgent(String agentId, int limit) throws ActionManagerException {
        return this.core.getHbaseClient().retrieveActionsByAgent(agentId, limit);
    }

    public void notify(String subscriptionId, String topic, String isId, String message) {
        this.notificationHandler.notified(subscriptionId, topic, isId, message);
    }

    public HBaseActionManagerCore getCore() {
        return this.core;
    }

    public void setCore(HBaseActionManagerCore core) {
        this.core = core;
    }

    public NotificationHandler getNotificationHandler() {
        return this.notificationHandler;
    }

    @Required
    public void setNotificationHandler(NotificationHandler notificationHandler) {
        this.notificationHandler = notificationHandler;
    }
}

