<%@page import="java.util.List"%>
<%@page import="eu.dnetlib.domain.EPR"%>
<%@page import="gr.uoa.di.driver.enabling.resultset.ResultSet"%>
<%@page import="eu.dnetlib.api.data.SearchService"%>

<jsp:useBean id="query" class="eu.dnetlib.data.search.web.Query" scope="request">
<jsp:setProperty name="query" property="*"/>
</jsp:useBean>

<% if (query == null) { %>
    <jsp:forward page="/"/>
<% } %>


<%@page import="org.apache.commons.lang.StringEscapeUtils"%>
<%@page import="eu.dnetlib.data.search.web.SearchServiceContextUtils"%>
<%@page import="gr.uoa.di.driver.enabling.resultset.ResultSetFactory"%>
<html>
	<head>
		<title>Index Refine</title>
	</head>
	<body>
		<h1>Index Refine</h1>
		Refine for <b>
		<% if (query.getQuery() == null || query.getQuery().length() == 0 ) { %>
			(empty query)
		<% } else { %>
			<%=query.getQuery()%>
		<% } %>
		</b>
		<% List<String> fields = query.parseFields(); %>
		using <%=(fields==null)?0:fields.size()%>fields: <b><%=fields%></b>
		in <a href="services/searchWebService">local search service</a>...<br>
		
<%
	long time = System.currentTimeMillis();
	SearchService search = SearchServiceContextUtils.getSearchService(request);
%>
	Created index endpoint in <%=System.currentTimeMillis()-time%> ms.<br>

<%
	time = System.currentTimeMillis();
	EPR epr = search.refine(query.getQuery(), fields);
%>
	Index lookup lasted <%=System.currentTimeMillis()-time%> ms.<br>
	Returned EPR: <pre><%=StringEscapeUtils.escapeHtml(epr.toString())%></pre><br>
	
<%
	time = System.currentTimeMillis();
	ResultSet<String> rs = SearchServiceContextUtils.getResultSetFactory(request).createResultSet(epr);
	int count = rs.size();
%>
	Total records in result set: <%=count%><br>
	Query Numof records lasted <%=System.currentTimeMillis()-time%> ms.<br>

<%
	time = System.currentTimeMillis();
	List<String> list = null;
	int MAX = 50;
	if (count > 0) {
		list = rs.getElements(1, Math.min(MAX, count));
	}
%>
	Retrieve top-<%=MAX%> records lasted <%=System.currentTimeMillis()-time%> ms.<br>

	Top-<%=MAX%> results:
	<table>
		<tr><th>Count</th><th>Record</th></tr>
	<% for (int i = 0 ; i < MAX && i < count; i++ ) { %>
		<tr>
			<td><%=i+1%></td>
			<td><pre><%=StringEscapeUtils.escapeHtml(list.get(i))%></pre></td>
		</tr>
	<% } %>
	</table>
	
	</body>
</html>

