<%@page import="java.util.List"%>
<%@page import="eu.dnetlib.domain.EPR"%>
<%@page import="gr.uoa.di.driver.enabling.resultset.ResultSet"%>
<%@page import="eu.dnetlib.api.data.SearchService"%>

<jsp:useBean id="query" class="eu.dnetlib.data.search.web.Query" scope="request">
<jsp:setProperty name="query" property="*"/>
</jsp:useBean>

<% if (query == null) { %>
    <jsp:forward page="/"/>
<% } %>

<%@page import="org.apache.commons.lang.StringEscapeUtils"%>
<%@page import="eu.dnetlib.data.search.web.SearchServiceContextUtils"%>
<%@page import="eu.dnetlib.domain.data.BrowseData"%>
<%@page import="eu.dnetlib.api.data.BrowseDataNotAvailableException"%>
<html>
	<head>
		<title>Index Browse</title>
	</head>
	<body>
		<h1>Index Browse</h1>
		Browse for <b>
		<% if (query.getQuery() == null || query.getQuery().length() == 0 ) { %>
			(empty query)
		<% } else { %>
			<%=query.getQuery()%>
		<% } %>
		</b>
		<% List<String> fields = query.parseFields(); %>
		<% String field = (fields==null)?null:fields.get(0); %>
		<% if (field == null) { %>
		<b>using no field</b>
		<% } else { %>
		<b>using field: <%=field %></b>
		<% } %>
		in <a href="services/searchWebService">local search service</a>...<br>
		

<%
	long time = System.currentTimeMillis();
	SearchService search = SearchServiceContextUtils.getSearchService(request);
%>
	Created index endpoint in <%=System.currentTimeMillis()-time%> ms.<br>

<%
	time = System.currentTimeMillis();
	BrowseData data = null;
	try {
		data = search.browse(query.getQuery(), field);
	} catch (BrowseDataNotAvailableException bdna) {
		data = null;
	}
%>
	Index lookup lasted <%=System.currentTimeMillis()-time%> ms.<br>
	
	<% if (data == null) { %>
	<i>Browse results are currently being updated...</i>
	<% } else { %>
	Browse results:
	<table>
		<tr><th>Field</th><th>Value</th><th>Count</th></tr>
		<%
		for (String f : data.getFields()) {
			List<Integer> counts = data.getFieldCounts(f);
			List<String> values = data.getFieldValues(f);
			for (int i=0; i<counts.size(); i++) {
		%>
		<tr>
			<td><%=f%></td>
			<td><%=values.get(i)%></td>
			<td><%=counts.get(i)%></td>
		</tr>
		<% }} %>
	</table>
	<% } %>
	</body>
</html>