/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.objectstore.modular.gridFS;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.gridfs.GridFS;
import com.mongodb.gridfs.GridFSDBFile;
import com.mongodb.gridfs.GridFSInputFile;
import eu.dnetlib.data.objectstore.modular.ObjectStoreRecord;
import eu.dnetlib.data.objectstore.modular.connector.ObjectStore;
import eu.dnetlib.data.objectstore.modular.gridFS.GridFSObjectstoreResultSetListener;
import eu.dnetlib.data.objectstore.rmi.MetadataObjectRecord;
import eu.dnetlib.data.objectstore.rmi.ObjectStoreFile;
import eu.dnetlib.data.objectstore.rmi.Protocols;
import eu.dnetlib.enabling.resultset.ResultSetListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GridFSObjectStore
implements ObjectStore {
    private static final Log log = LogFactory.getLog(GridFSObjectStore.class);
    private String id;
    private boolean upsert;
    private GridFS collection;
    private String baseURI;

    public GridFSObjectStore(String id, GridFS collection, boolean upsert) {
        this.id = id;
        this.setUpsert(upsert);
        this.collection = collection;
    }

    public String getId() {
        return this.id;
    }

    public int feedMetadataRecord(Iterable<MetadataObjectRecord> records, boolean incremental) {
        long timestamp = System.currentTimeMillis();
        for (MetadataObjectRecord o : records) {
            if (o.getRecord() == null) {
                log.debug((Object)("Null object " + o.getId()));
                continue;
            }
            GridFSInputFile currentFile = this.collection.createFile((InputStream)new ByteArrayInputStream(o.getRecord().getBytes()));
            currentFile.setId((Object)o.getId());
            BasicDBObject metadata = new BasicDBObject();
            metadata.put("id", (Object)o.getId());
            metadata.put("mime", (Object)o.getMime());
            metadata.put("timestamp", (Object)timestamp);
            try {
                String URI = this.baseURI + "?objectStore=" + URLEncoder.encode(this.id, "UTF-8") + "&objectId=" + URLEncoder.encode(o.getId(), "UTF-8");
                metadata.put("uri", (Object)URI);
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)"Got an exception during the feed ", (Throwable)e);
            }
            currentFile.setMetaData((DBObject)metadata);
            currentFile.save();
        }
        return this.getSize();
    }

    public int feed(Iterable<ObjectStoreRecord> records, boolean incremental) {
        long timestamp = System.currentTimeMillis();
        int time = 0;
        for (ObjectStoreRecord o : records) {
            if (o == null || o.getInputStream() == null) {
                if (o != null) {
                    log.debug((Object)("Null object " + o.getFileMetadata().toJSON()));
                } else {
                    log.debug((Object)"Null Object");
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    log.error((Object)e);
                }
                continue;
            }
            if (this.alreadyExist(o.getFileMetadata().getObjectID())) {
                try {
                    o.getInputStream().close();
                }
                catch (IOException e) {}
                continue;
            }
            if (time++ > 100) {
                try {
                    time = 0;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            GridFSInputFile currentFile = this.collection.createFile(o.getInputStream());
            currentFile.setId((Object)o.getFileMetadata().getObjectID());
            currentFile.setFilename(o.getFileMetadata().getObjectID());
            BasicDBObject metadata = new BasicDBObject();
            metadata.put("id", (Object)o.getFileMetadata().getObjectID());
            metadata.put("mime", (Object)o.getFileMetadata().getMimeType());
            metadata.put("originalObject", (Object)o.getFileMetadata().toJSON());
            metadata.put("timestamp", (Object)timestamp);
            try {
                String URI = this.baseURI + "?objectStore=" + URLEncoder.encode(this.id, "UTF-8") + "&objectId=" + URLEncoder.encode(o.getFileMetadata().getObjectID(), "UTF-8");
                metadata.put("uri", (Object)URI);
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)"Got an exception during the feed ", (Throwable)e);
            }
            currentFile.setMetaData((DBObject)metadata);
            currentFile.save();
        }
        return this.getSize();
    }

    public ResultSetListener deliver(Double from, Double until) {
        GridFSObjectstoreResultSetListener resulset = new GridFSObjectstoreResultSetListener();
        resulset.setBaseURI(this.baseURI);
        resulset.setObjectStoreID(this.id);
        resulset.setCollection(this.collection);
        resulset.setFromDate(from);
        resulset.setUntilDate(until);
        return resulset;
    }

    public ResultSetListener deliverIds(Iterable<String> ids) {
        GridFSObjectstoreResultSetListener resulset = new GridFSObjectstoreResultSetListener();
        resulset.setBaseURI(this.baseURI);
        resulset.setObjectStoreID(this.id);
        resulset.setCollection(this.collection);
        resulset.setRecords((List)ids);
        return resulset;
    }

    public int getSize() {
        return this.collection.getFileList().count();
    }

    public void deleteObject(String objectId) {
    }

    public String getObject(String recordId) {
        return null;
    }

    public String getInterpretation() {
        return (String)this.getMDStoreMetadata().get("interpretation");
    }

    public DBObject getMDStoreMetadata() {
        return this.collection.getDB().getCollection("metadataObjectStore").findOne((DBObject)new BasicDBObject("obsId", (Object)Pattern.compile(this.getId())));
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    public boolean isUpsert() {
        return this.upsert;
    }

    public void setUpsert(boolean upsert) {
        this.upsert = upsert;
    }

    private boolean alreadyExist(String objectId) {
        BasicDBObject query = new BasicDBObject("_id", (Object)objectId);
        List file = this.collection.find((DBObject)query);
        return file != null && file.size() > 0;
    }

    public ObjectStoreFile deliverObject(String objectId) {
        BasicDBObject query = new BasicDBObject("_id", (Object)objectId);
        List file = this.collection.find((DBObject)query);
        for (GridFSDBFile f : file) {
            DBObject outObject = f.getMetaData();
            if (!outObject.get("id").equals(objectId)) continue;
            ObjectStoreFile outFile = new ObjectStoreFile();
            outFile.setObjectID(objectId);
            outFile.setMimeType((String)outObject.get("mime"));
            outFile.setAccessProtocol(Protocols.HTTP);
            try {
                outFile.setURI(this.baseURI + "?objectStore=" + URLEncoder.encode(this.id, "UTF-8") + "&objectId=" + URLEncoder.encode(objectId, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)e);
            }
            return outFile;
        }
        return null;
    }

    public InputStream deliverStream(String objectId) {
        BasicDBObject query = new BasicDBObject("_id", (Object)objectId);
        List file = this.collection.find((DBObject)query);
        for (GridFSDBFile f : file) {
            if (!f.getMetaData().get("id").equals(objectId)) continue;
            return f.getInputStream();
        }
        return null;
    }

    public String feedObjectRecord(ObjectStoreRecord record) {
        ObjectStoreFile obj = this.deliverObject(record.getFileMetadata().getObjectID());
        if (obj.getObjectID() == record.getFileMetadata().getObjectID()) {
            return obj.getURI();
        }
        long timestamp = System.currentTimeMillis();
        String URI = "";
        if (record.getInputStream() == null) {
            return null;
        }
        GridFSInputFile currentFile = this.collection.createFile(record.getInputStream());
        currentFile.setId((Object)record.getFileMetadata().getObjectID());
        currentFile.setFilename(record.getFileMetadata().getObjectID());
        BasicDBObject metadata = new BasicDBObject();
        metadata.put("id", (Object)record.getFileMetadata().getObjectID());
        metadata.put("mime", (Object)record.getFileMetadata().getMimeType());
        metadata.put("originalObject", (Object)record.getFileMetadata().toJSON());
        metadata.put("timestamp", (Object)timestamp);
        try {
            URI = this.baseURI + "?objectStore=" + URLEncoder.encode(this.id, "UTF-8") + "&objectId=" + URLEncoder.encode(record.getFileMetadata().getObjectID(), "UTF-8");
            metadata.put("uri", (Object)URI);
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e);
        }
        currentFile.setMetaData((DBObject)metadata);
        currentFile.save();
        return URI;
    }

    public boolean existIDStartsWith(String startId) {
        GridFSDBFile out = this.collection.findOne((DBObject)new BasicDBObject("_id", (Object)Pattern.compile(startId)));
        return out != null;
    }
}

