package eu.dnetlib.data.objectstore.modular.gridFS;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;

import com.mongodb.MongoOptions;

public class MongoGridFSOptionsFactory implements FactoryBean {

	private int connectionsPerHost;

	@Override
	public Object getObject() throws BeansException {
		MongoOptions opts = new MongoOptions();
		opts.connectionsPerHost = connectionsPerHost;
		return opts;
	}

	@SuppressWarnings("rawtypes")
	@Override
	public Class getObjectType() {
		return MongoOptions.class;
	}

	@Override
	public boolean isSingleton() {
		return false;
	}

	public int getConnectionsPerHost() {
		return connectionsPerHost;
	}

	public void setConnectionsPerHost(int connectionsPerHost) {
		this.connectionsPerHost = connectionsPerHost;
	}

}
