package eu.dnetlib.data.mapreduce.hbase.dedup;

import java.io.IOException;
import java.util.Properties;

import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableOutputFormat;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;

import eu.dnetlib.data.mapreduce.JobParams;
import eu.dnetlib.data.mapreduce.hbase.AbstractHBaseMapReduceJob;
import eu.dnetlib.data.mapreduce.hbase.dedup.config.DedupConfig;
import eu.dnetlib.data.mapreduce.hbase.dedup.config.DedupConfigLoader;
import eu.dnetlib.data.proto.RelTypeProtos.RelType;

public class DedupGrouperJob extends AbstractHBaseMapReduceJob {

	@Override
	public Job setJobDetails(Job job, Properties p) {

		initMapper(job, getScan(p), p.getProperty(JobParams.HBASE_SOURCE_TABLE));

		job.setOutputFormatClass(TableOutputFormat.class);
		job.setMapOutputKeyClass(Text.class);
		job.setMapOutputValueClass(Put.class);

		//job.setNumReduceTasks(200);
		job.setNumReduceTasks(0);

		job.getConfiguration().setBoolean("mapred.map.tasks.speculative.execution", false);
		job.getConfiguration().setBoolean("mapreduce.map.speculative", false);

		SequenceFileOutputFormat.setCompressOutput(job, false);

		Path path = new Path(p.getProperty(JobParams.INDEX_SEQ_FILE));
		SequenceFileOutputFormat.setOutputPath(job, path);
		job.getConfiguration().setBoolean("mapred.compress.map.output", true);

		return job;
	}

	private Scan getScan(Properties p) {
		Scan scan = new Scan();
		scan.setCaching(500); // 1 is the default in Scan, which will be bad for MapReduce jobs
		scan.setCacheBlocks(false); // don't set to true for MR jobs

		//Filter filter = new FilterList(new PrefixFilter("person|".getBytes()), new PageFilter(1000));
		//Filter filter = new PrefixFilter("person|pubmed".getBytes());
		DedupConfig dedupConfig = DedupConfigLoader.load(p.getProperty("dedup.wf.conf"));
		//filter.addFilter(new ColumnPrefixFilter(Bytes.toBytes("similarRel")));

		scan.setFilter(new PrefixFilter(Bytes.toBytes(dedupConfig.getEntityId())));
		scan.addFamily(RelType.similarRel.toString().getBytes());
		return scan;
	}

	private void initMapper(final Job job, final Scan scan, final String sourceTable) {
		try {
			TableMapReduceUtil.initTableMapperJob(sourceTable, scan, DedupGrouperMapper.class, Text.class, Put.class, job);
			//TableMapReduceUtil.initTableReducerJob(sourceTable, DedupGrouperReducer.class, job);
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
	}

}
