package eu.dnetlib.data.mapreduce.hbase.dedup.config;

import java.io.StringReader;
import java.util.List;
import java.util.Set;

import com.google.common.collect.Sets;
import com.typesafe.config.ConfigFactory;

import eu.dnetlib.data.proto.TypeProtos.Type;

public class DedupConfigLoader {

	private com.typesafe.config.Config config;

	public static DedupConfig load(String s) {
		DedupConfigLoader cfg = new DedupConfigLoader();
		cfg.loadConf(s);
		return cfg.parseFields("");
	}

	protected void loadConf(String s) {
		config = ConfigFactory.parseReader(new StringReader(s));
	}

	private DedupConfig parseFields(final String base) {
		return new DedupConfig(
				Type.valueOf(getString("dedup.conf.entity.type")),
				getString("dedup.conf.order.field"),
				getStringList("dedup.conf.rootbuilder"),
				getString("dedup.conf.run"),
				getDouble("dedup.conf.threshold"),
				getStringSet("dedup.conf.skiplist"));
	}
	
	protected Object safe(String path) {
		return config.hasPath(path) ? config.getAnyRef(path) : null;
	}
	
	public String getString(String path) {
		return (String) safe(path);
	}
	
	public Double getDouble(String path) {
		Object safe = safe(path);
		if (safe instanceof Integer) {
			return Double.parseDouble(safe.toString());
		}
		return (Double) safe;
	}	
	
	@SuppressWarnings("unchecked")
	public List<String> getStringList(String path) {
		return (List<String>) safe(path);
	}
	
	@SuppressWarnings("unchecked")
	public Set<String> getStringSet(String path) {
		final List<String> list = getStringList(path);
		return (Set<String>) (list != null ? Sets.newHashSet(list) : Sets.newHashSet());
	}	

}
