package eu.dnetlib.data.mapreduce.util;

import org.apache.hadoop.hbase.io.ImmutableBytesWritable;

import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.InvalidProtocolBufferException;

import eu.dnetlib.data.proto.KindProtos.Kind;
import eu.dnetlib.data.proto.OafProtos.Oaf;
import eu.dnetlib.data.proto.OafProtos.OafEntity;
import eu.dnetlib.data.proto.OafProtos.OafRel;
import eu.dnetlib.data.proto.RelTypeProtos.RelType;

public class OafDecoder {

	private Oaf oaf;

	public static OafDecoder decode(ImmutableBytesWritable oaf) {
		return new OafDecoder(oaf.copyBytes());
	}

	public static OafDecoder decode(Oaf oaf) {
		return new OafDecoder(oaf);
	}

	public static OafDecoder decode(byte[] oaf) {
		return new OafDecoder(oaf);
	}

	private OafDecoder(byte[] value) {
		try {
			this.oaf = Oaf.parseFrom(value);
		} catch (InvalidProtocolBufferException e) {
			throw new RuntimeException("unable to deserialize proto: " + new String(value));
		}
	}

	private OafDecoder(Oaf oaf) {
		this.oaf = oaf;
	}

	public Kind getKind() {
		return oaf.getKind();
	}
	
	public Oaf getOaf() {
		return oaf;
	}

	/// Entity

	public GeneratedMessage getMetadata() {
		return decodeEntity().getMetadata();
	}

	public GeneratedMessage getOafEntity() {
		return decodeEntity().getEntity();
	}

	public String getEntityId() {
		return decodeEntity().getId();
	}

	public OafEntity getEntity() {
		return oaf.getEntity();
	}

	private OafEntityDecoder decodeEntity() {
		return OafEntityDecoder.decode(getEntity());
	}

	/// Rel

	public OafRel getOafRel() {
		return oaf.getRel();
	}

	public GeneratedMessage getRel() {
		return decodeRel().getRel();
	}

	public RelType relType() {
		return decodeRel().getRelType();
	}

	public String relTypeName() {
		return relType().toString();
	}

	public String relSourceId() {
		return decodeRel().getRelSourceId();
	}

	public String relTargetId() {
		return decodeRel().getRelTargetId();
	}

	private OafRelDecoder decodeRel() {
		return OafRelDecoder.decode(getOafRel());
	}

	public byte[] toByteArray() {
		return oaf.toByteArray();
	}

}
