package eu.dnetlib.data.mapreduce.util;

import com.google.protobuf.Descriptors.FieldDescriptor;
import com.google.protobuf.GeneratedMessage;

import eu.dnetlib.data.proto.OafProtos.OafEntity;
import eu.dnetlib.data.proto.OafProtos.OafRel;
import eu.dnetlib.data.proto.RelMetadataProtos.RelMetadata;
import eu.dnetlib.data.proto.RelTypeProtos.RelType;

public class OafRelDecoder {

	private final OafRel oafRel;

	public static OafRelDecoder decode(OafRel oafRel) {
		return new OafRelDecoder(oafRel);
	}

	private OafRelDecoder(OafRel oafRel) {
		this.oafRel = oafRel;
	}

	public RelType getRelType() {
		return oafRel.getRelType();
	}

	public GeneratedMessage getRel() {

		FieldDescriptor fd = oafRel.getDescriptorForType().findFieldByName(relTypeName());
		return (GeneratedMessage) oafRel.getField(fd);
	}

	public RelMetadata getRelMetadata() {
		GeneratedMessage rel = getRel();
		FieldDescriptor fd = rel.getDescriptorForType().findFieldByName("relMetadata");
		return fd != null ? (RelMetadata) rel.getField(fd) : null;
	}

	public String getCachedTargedId() {

		if (!oafRel.hasCachedTarget()) {
			return null;
		}

		final OafEntity entity = oafRel.getCachedTarget();
		return OafEntityDecoder.decode(entity).getId();
	}

	public String getRelSourceId() {
		return oafRel.getSource();
	}

	public String getRelTargetId() {
		return oafRel.getTarget();
	}

	public String relTypeName() {
		return getRelType().toString();
	}

}
