/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup;

import eu.dnetlib.data.mapreduce.hbase.AbstractHBaseMapReduceJob;
import eu.dnetlib.data.mapreduce.hbase.dedup.FindPersonCoauthorsMapper;
import eu.dnetlib.data.proto.TypeProtos;
import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableOutputFormat;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;

public class FindPersonCoauthorsJob
extends AbstractHBaseMapReduceJob {
    private static final String RESULT_SCAN_PREFIX = TypeProtos.Type.result.getNumber() + "|";

    @Override
    public Job setJobDetails(Job job, Properties p) {
        p.setProperty("mapred.reduce.tasks.speculative.execution", "true");
        this.initMapper(job, this.getScan(p), p.getProperty("hbase.source.table"));
        job.setOutputFormatClass(TableOutputFormat.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(Put.class);
        job.setNumReduceTasks(0);
        return job;
    }

    private Scan getScan(Properties p) {
        Scan scan = new Scan();
        scan.setCaching(100);
        scan.setCacheBlocks(false);
        scan.setFilter((Filter)new PrefixFilter(Bytes.toBytes((String)RESULT_SCAN_PREFIX)));
        return scan;
    }

    private void initMapper(Job job, Scan scan, String sourceTable) {
        try {
            TableMapReduceUtil.initTableMapperJob((String)sourceTable, (Scan)scan, FindPersonCoauthorsMapper.class, Text.class, ImmutableBytesWritable.class, (Job)job);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

