/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup.config;

import com.google.common.collect.Sets;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import eu.dnetlib.data.mapreduce.hbase.dedup.config.DedupConfig;
import eu.dnetlib.data.proto.TypeProtos;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Set;

public class DedupConfigLoader {
    private Config config;

    public static DedupConfig load(String s) {
        DedupConfigLoader cfg = new DedupConfigLoader();
        cfg.loadConf(s);
        return cfg.parseFields("");
    }

    protected void loadConf(String s) {
        this.config = ConfigFactory.parseReader((Reader)new StringReader(s));
    }

    private DedupConfig parseFields(String base) {
        return new DedupConfig(TypeProtos.Type.valueOf((String)this.getString("dedup.conf.entity.type")), this.getString("dedup.conf.order.field"), this.getStringList("dedup.conf.rootbuilder"), this.getString("dedup.conf.run"), this.getDouble("dedup.conf.threshold"), this.getStringSet("dedup.conf.skiplist"));
    }

    protected Object safe(String path) {
        return this.config.hasPath(path) ? this.config.getAnyRef(path) : null;
    }

    public String getString(String path) {
        return (String)this.safe(path);
    }

    public Double getDouble(String path) {
        Object safe = this.safe(path);
        if (safe instanceof Integer) {
            return Double.parseDouble(safe.toString());
        }
        return (Double)safe;
    }

    public List<String> getStringList(String path) {
        return (List)this.safe(path);
    }

    public Set<String> getStringSet(String path) {
        List<String> list = this.getStringList(path);
        return list != null ? Sets.newHashSet(list) : Sets.newHashSet();
    }
}

