/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.index;

import com.google.protobuf.Descriptors;
import eu.dnetlib.data.mapreduce.hbase.index.config.ContextMapper;
import eu.dnetlib.data.mapreduce.hbase.index.config.EntityLinkTable;
import eu.dnetlib.data.mapreduce.hbase.index.config.IndexConfig;
import eu.dnetlib.data.mapreduce.util.OafDecoder;
import eu.dnetlib.data.mapreduce.util.XmlRecordFactory;
import eu.dnetlib.data.proto.TypeProtos;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

public class PrepareFeedReducer
extends Reducer<Text, ImmutableBytesWritable, Text, Text> {
    private EntityLinkTable entityLinkTable;
    private ContextMapper contextMapper = new ContextMapper();
    private final boolean entityDefaults = true;
    private final boolean relDefaults = false;
    private final boolean childDefaults = false;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        String json = context.getConfiguration().get("index.entity.links");
        System.out.println("index.entity.links:\n" + json);
        this.entityLinkTable = IndexConfig.load(json).getLinkMap();
        json = context.getConfiguration().get("contextmap");
        System.out.println("contextmap:\n" + json);
        this.contextMapper.fromJson(json);
    }

    protected void reduce(Text key, Iterable<ImmutableBytesWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        XmlRecordFactory builder = new XmlRecordFactory(this.entityLinkTable, this.contextMapper, true, false, false);
        this.decodeValues(values, builder);
        if (builder.isValid()) {
            context.write((Object)key, (Object)new Text(builder.build()));
        } else {
            context.getCounter("missing body", this.getType(key)).increment(1L);
        }
    }

    private void decodeValues(Iterable<ImmutableBytesWritable> values, XmlRecordFactory builder) {
        block4: for (ImmutableBytesWritable bytes : values) {
            OafDecoder decoder = OafDecoder.decode(bytes);
            switch (decoder.getKind()) {
                case entity: {
                    builder.setMainEntity(decoder.getEntity());
                    continue block4;
                }
                case relation: {
                    if (decoder.getOafRel().getChild()) {
                        builder.addChild(decoder.getOafRel());
                        continue block4;
                    }
                    builder.addRelation(decoder.getOafRel());
                    continue block4;
                }
            }
            throw new IllegalArgumentException("unknow type: " + decoder.getKind());
        }
    }

    private String getType(Text key) {
        try {
            return TypeProtos.Type.valueOf((Descriptors.EnumValueDescriptor)TypeProtos.Type.getDescriptor().findValueByNumber(Integer.parseInt(StringUtils.left((String)key.toString(), (int)2)))).toString();
        }
        catch (Throwable e) {
            return "record";
        }
    }
}

