/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.util;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.protobuf.Descriptors;
import com.google.protobuf.GeneratedMessage;
import eu.dnetlib.data.mapreduce.hbase.index.config.ContextDef;
import eu.dnetlib.data.mapreduce.hbase.index.config.ContextMapper;
import eu.dnetlib.data.mapreduce.hbase.index.config.EntityLinkTable;
import eu.dnetlib.data.mapreduce.util.LicenseComparator;
import eu.dnetlib.data.mapreduce.util.OafEntityDecoder;
import eu.dnetlib.data.mapreduce.util.OafRelDecoder;
import eu.dnetlib.data.mapreduce.util.TemplateFactory;
import eu.dnetlib.data.proto.KeyValueProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.QualifierProtos;
import eu.dnetlib.data.proto.RelMetadataProtos;
import eu.dnetlib.data.proto.RelTypeProtos;
import eu.dnetlib.data.proto.ResultProtos;
import eu.dnetlib.data.proto.StructuredPropertyProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.miscutils.collections.MappedCollection;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import java.io.Reader;
import java.io.StringReader;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.json.JSONObject;
import org.json.XML;

public class XmlRecordFactory {
    protected Set<String> specialDatasourceTypes = Sets.newHashSet((Object[])new String[]{"scholarcomminfra", "infospace", "pubsrepository::mock", "entityregistry"});
    protected TemplateFactory templateFactory = new TemplateFactory();
    protected OafEntityDecoder mainEntity = null;
    protected String id = null;
    protected Map<String, OafProtos.OafRel> relations = Maps.newHashMap();
    protected Map<String, OafProtos.OafRel> children = Maps.newHashMap();
    protected EntityLinkTable entityLinkTable;
    protected ContextMapper contextMapper;
    protected boolean entityDefaults;
    protected boolean relDefaults;
    protected boolean childDefaults;

    public XmlRecordFactory(EntityLinkTable entityLinkTable, ContextMapper contextMapper, boolean entityDefaults, boolean relDefaults, boolean childDefeaults) {
        this.entityLinkTable = entityLinkTable;
        this.contextMapper = contextMapper;
        this.entityDefaults = entityDefaults;
        this.relDefaults = relDefaults;
        this.childDefaults = childDefeaults;
    }

    public String getId() {
        return this.id;
    }

    public boolean isValid() {
        return this.mainEntity != null;
    }

    public void setMainEntity(OafProtos.OafEntity entity) {
        this.mainEntity = OafEntityDecoder.decode(entity);
        this.id = this.mainEntity.getId();
    }

    public void addRelation(OafProtos.OafRel rel) {
        this.addRelOrChild(this.relations, rel);
    }

    public void addChild(OafProtos.OafRel child) {
        this.addRelOrChild(this.children, child);
    }

    private void addRelOrChild(Map<String, OafProtos.OafRel> map, OafProtos.OafRel rel) {
        if (!rel.getSource().equals(this.getId())) {
            map.put(rel.getSource(), rel);
        } else {
            map.put(UUID.randomUUID().toString(), rel);
        }
    }

    public String build() {
        TypeProtos.Type type = this.mainEntity.getType();
        List<String> metadata = this.decodeType(this.mainEntity, null, this.entityDefaults, false);
        String body = this.templateFactory.buildBody(type, metadata, this.listRelations(), this.listChildren());
        return this.templateFactory.buildRecord(type, this.mainEntity.getId(), this.mainEntity.getDateOfCollection(), body);
    }

    private List<String> decodeType(OafEntityDecoder decoder, Set<String> filter, boolean defaults, boolean expandingRel) {
        ArrayList metadata = Lists.newArrayList();
        metadata.addAll(this.listFields(decoder.getMetadata(), filter, defaults, expandingRel));
        metadata.addAll(this.listFields(decoder.getOafEntity(), filter, defaults, expandingRel));
        if (this.mainEntity.getEntity() instanceof ResultProtos.Result && !expandingRel) {
            metadata.add(this.asXmlElement("bestlicense", "", this.getBestLicense()));
        }
        return metadata;
    }

    private QualifierProtos.Qualifier getBestLicense() {
        QualifierProtos.Qualifier bestLicense = null;
        LicenseComparator lc = new LicenseComparator();
        for (ResultProtos.Result.Instance instance : ((ResultProtos.Result)this.mainEntity.getEntity()).getInstanceList()) {
            if (lc.compare(bestLicense, instance.getLicence()) <= 0) continue;
            bestLicense = instance.getLicence();
        }
        return bestLicense;
    }

    private List<String> listRelations() {
        ArrayList rels = Lists.newArrayList();
        for (OafProtos.OafRel rel : this.relations.values()) {
            OafProtos.OafEntity cachedTarget = rel.getCachedTarget();
            OafRelDecoder relDecoder = OafRelDecoder.decode(rel);
            if (relDecoder.getRelType().equals((Object)RelTypeProtos.RelType.personResult) && !relDecoder.getRelTargetId().equals(this.id)) continue;
            Set<String> filter = this.entityLinkTable.getFilter(cachedTarget.getType(), relDecoder.getRelType());
            List<String> metadata = this.decodeType(OafEntityDecoder.decode(cachedTarget), filter, this.relDefaults, true);
            metadata.addAll(this.listFields(relDecoder.getRel(), null, false, true));
            RelMetadataProtos.RelMetadata relMetadata = relDecoder.getRelMetadata();
            String semanticclass = "";
            String semanticscheme = "";
            if (relMetadata == null) {
                System.err.println(this);
                semanticscheme = "UNKNOWN";
                semanticclass = "UNKNOWN";
            } else {
                semanticclass = relMetadata.getSemantics().getClassname();
                semanticscheme = relMetadata.getSemantics().getSchemename();
            }
            rels.add(this.templateFactory.getRel(cachedTarget.getType(), relDecoder.getRelSourceId(), metadata, semanticclass, semanticscheme));
        }
        return rels;
    }

    private List<String> listChildren() {
        ArrayList children = Lists.newArrayList();
        for (OafProtos.OafRel rel : this.children.values()) {
            this.addChildren(children, rel.getCachedTarget(), rel.getRelType());
        }
        if (this.mainEntity.getType().equals((Object)TypeProtos.Type.result)) {
            for (ResultProtos.Result.Instance instance : ((ResultProtos.Result)this.mainEntity.getEntity()).getInstanceList()) {
                children.add(this.templateFactory.getInstance(instance.getHostedby().getKey(), this.listFields((GeneratedMessage)instance, null, false, false), MappedCollection.listMap((Iterable)instance.getUrlList(), (UnaryFunction)new UnaryFunction<String, String>(){

                    public String evaluate(String identifier) {
                        return XmlRecordFactory.this.templateFactory.getWebResource(identifier);
                    }
                })));
            }
            for (ResultProtos.Result.ExternalReference er : ((ResultProtos.Result)this.mainEntity.getEntity()).getExternalReferenceList()) {
                Set<String> filters = this.entityLinkTable.getFilter(TypeProtos.Type.result, RelTypeProtos.RelType.resultResult);
                List<String> fields = this.listFields((GeneratedMessage)er, filters, false, false);
                children.add(this.templateFactory.getChild("externalreference", null, fields));
            }
        }
        return children;
    }

    private void addChildren(List<String> children, OafProtos.OafEntity target, RelTypeProtos.RelType relType) {
        OafEntityDecoder decoder = OafEntityDecoder.decode(target);
        Set<String> filters = this.entityLinkTable.getFilter(target.getType(), relType);
        children.add(this.templateFactory.getChild(decoder.getType().toString(), decoder.getId(), this.listFields(decoder.getMetadata(), filters, this.childDefaults, false)));
    }

    private List<String> listFields(GeneratedMessage fields, Set<String> filter, boolean defaults, boolean expandingRel) {
        ArrayList metadata = Lists.newArrayList();
        if (fields != null) {
            HashSet seen = Sets.newHashSet();
            for (Map.Entry<Descriptors.FieldDescriptor, Object> e : this.filterFields(fields, filter)) {
                String name = e.getKey().getName();
                seen.add(name);
                this.addFieldValue(metadata, e.getKey(), e.getValue(), expandingRel);
            }
            if (defaults) {
                for (Descriptors.FieldDescriptor fd : fields.getDescriptorForType().getFields()) {
                    if (seen.contains(fd.getName())) continue;
                    this.addFieldValue(metadata, fd, this.getDefault(fd), expandingRel);
                }
            }
        }
        return metadata;
    }

    private Object getDefault(Descriptors.FieldDescriptor fd) {
        switch (fd.getType()) {
            case BOOL: {
                return false;
            }
            case BYTES: {
                return "".getBytes();
            }
            case MESSAGE: {
                if ("Qualifier".equals(fd.getMessageType().getName())) {
                    return this.defaultQualifier();
                }
                if ("StructuredProperty".equals(fd.getMessageType().getName())) {
                    return StructuredPropertyProtos.StructuredProperty.newBuilder().setValue("").setQualifier(this.defaultQualifier()).build();
                }
                if ("KeyValue".equals(fd.getMessageType().getName())) {
                    return KeyValueProtos.KeyValue.newBuilder().setKey("").setValue("").build();
                }
                return null;
            }
            case SFIXED32: 
            case SFIXED64: 
            case SINT32: 
            case SINT64: 
            case INT32: 
            case INT64: 
            case DOUBLE: 
            case FIXED32: 
            case FIXED64: 
            case FLOAT: {
                return 0;
            }
            case STRING: {
                return "";
            }
        }
        return null;
    }

    private QualifierProtos.Qualifier defaultQualifier() {
        return QualifierProtos.Qualifier.newBuilder().setClassid("").setClassname("").setSchemeid("").setSchemename("").build();
    }

    private void addFieldValue(List<String> metadata, Descriptors.FieldDescriptor fd, Object value, boolean expandingRel) {
        if (fd.getName().equals("dateofcollection") || fd.getName().equals("id")) {
            return;
        }
        if (fd.getName().equals("datasourcetype")) {
            String classid = ((QualifierProtos.Qualifier)value).getClassid();
            QualifierProtos.Qualifier.Builder q = QualifierProtos.Qualifier.newBuilder((QualifierProtos.Qualifier)((QualifierProtos.Qualifier)value));
            if (this.specialDatasourceTypes.contains(classid)) {
                q.setClassid("other").setClassname("other");
            }
            metadata.add(this.asXmlElement("datasourcetypeui", "", q.build()));
        }
        if (fd.isRepeated() && value instanceof List) {
            for (Object o : (List)value) {
                this.guessType(metadata, fd, o, expandingRel);
            }
        } else {
            this.guessType(metadata, fd, value, expandingRel);
        }
    }

    private void guessType(List<String> metadata, Descriptors.FieldDescriptor fd, Object o, boolean expandingRel) {
        if (fd.getType().equals((Object)Descriptors.FieldDescriptor.Type.MESSAGE)) {
            if (QualifierProtos.Qualifier.getDescriptor().equals(fd.getMessageType())) {
                QualifierProtos.Qualifier qualifier = (QualifierProtos.Qualifier)o;
                metadata.add(this.asXmlElement(fd.getName(), "", qualifier));
            }
            if (StructuredPropertyProtos.StructuredProperty.getDescriptor().equals(fd.getMessageType())) {
                StructuredPropertyProtos.StructuredProperty sp = (StructuredPropertyProtos.StructuredProperty)o;
                metadata.add(this.asXmlElement(fd.getName(), sp.getValue(), sp.getQualifier()));
            }
            if (KeyValueProtos.KeyValue.getDescriptor().equals(fd.getMessageType())) {
                KeyValueProtos.KeyValue kv = (KeyValueProtos.KeyValue)o;
                metadata.add("<" + fd.getName() + " name=\"" + XmlRecordFactory.escapeXml(kv.getValue()) + "\" id=\"" + XmlRecordFactory.escapeXml(XmlRecordFactory.removePrefix(kv.getKey())) + "\"/>");
            }
            if (ResultProtos.Result.Journal.getDescriptor().equals(fd.getMessageType()) && o != null) {
                ResultProtos.Result.Journal j = (ResultProtos.Result.Journal)o;
                metadata.add("<journal issn=\"" + XmlRecordFactory.escapeXml(j.getIssnPrinted()) + "\" " + "eissn=\"" + XmlRecordFactory.escapeXml(j.getIssnOnline()) + "\" " + "lissn=\"" + XmlRecordFactory.escapeXml(j.getIssnLinking()) + "\">" + j.getName() + "</journal>");
            }
            if (ResultProtos.Result.Context.getDescriptor().equals(fd.getMessageType()) && o != null) {
                this.handleContext(metadata, fd, o, expandingRel);
            }
        } else if (!fd.getType().equals((Object)Descriptors.FieldDescriptor.Type.ENUM)) {
            if (fd.getName().contains("fundingtree")) {
                this.handleFundingTree(metadata, fd, o, expandingRel);
            } else {
                metadata.add(this.asXmlElement(fd.getName(), o.toString(), null));
            }
        }
    }

    private void handleContext(List<String> metadata, Descriptors.FieldDescriptor fd, Object o, boolean expandingRel) {
        ResultProtos.Result.Context context = (ResultProtos.Result.Context)o;
        String fullid = context.getId();
        ArrayList ids = Lists.newArrayList();
        if (this.contextMapper.isEmpty()) {
            return;
        }
        while (fullid.contains("::")) {
            fullid = StringUtils.substringBeforeLast((String)fullid, (String)"::");
            ids.add(fullid);
        }
        for (String id : ids) {
            ContextDef def = (ContextDef)this.contextMapper.get(id);
            metadata.add("<" + def.getElement() + " id=\"" + id + "\" label=\"" + def.getLabel() + "\"/>");
        }
    }

    private void handleFundingTree(List<String> metadata, Descriptors.FieldDescriptor fd, Object o, boolean expandingRel) {
        String xmlTree = this.asXmlJSon(fd.getName(), o.toString());
        if (expandingRel) {
            try {
                Document ftree = new SAXReader().read((Reader)new StringReader(xmlTree));
                int i = 0;
                String funding = "<funding>";
                String _id = "";
                for (Object id : Lists.reverse((List)ftree.selectNodes("//fundingtree//name"))) {
                    _id = _id + ((Element)id).getText();
                    funding = funding + "<funding_level_" + i + ">" + XmlRecordFactory.escapeXml(_id) + "</funding_level_" + i + ">";
                    _id = _id + "::";
                    ++i;
                }
                funding = funding + "</funding>";
                metadata.add(funding);
            }
            catch (DocumentException e) {
                System.err.println("unable to parse funding tree: " + xmlTree + "\n" + e.getMessage());
            }
        } else {
            metadata.add(xmlTree);
        }
    }

    private String asXmlJSon(String root, String json) {
        try {
            if (json == null || json.isEmpty()) {
                return "<" + root + "/>";
            }
            JSONObject o = new JSONObject(json);
            String xml = XML.toString((Object)o, (String)root);
            return xml;
        }
        catch (Exception e) {
            System.err.println("unable to parse json: " + json + "\n" + e.getMessage());
            return "<" + root + "/>";
        }
    }

    private String asXmlElement(String name, String value, QualifierProtos.Qualifier q) {
        StringBuilder sb = new StringBuilder();
        sb.append("<");
        sb.append(name);
        sb.append(this.getAttributes(q));
        if (value == null || value.isEmpty()) {
            sb.append("/>");
            return sb.toString();
        }
        sb.append(">");
        sb.append(XmlRecordFactory.escapeXml(Normalizer.normalize(value, Normalizer.Form.NFD)));
        sb.append("</");
        sb.append(name);
        sb.append(">");
        return sb.toString();
    }

    private String getAttributes(QualifierProtos.Qualifier q) {
        if (q == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry e : q.getAllFields().entrySet()) {
            sb.append(" ");
            sb.append(((Descriptors.FieldDescriptor)e.getKey()).getName());
            sb.append("=\"");
            sb.append(XmlRecordFactory.escapeXml(Normalizer.normalize(e.getValue().toString(), Normalizer.Form.NFD)));
            sb.append("\"");
        }
        return sb.toString();
    }

    private Set<Map.Entry<Descriptors.FieldDescriptor, Object>> filterFields(final GeneratedMessage fields, final Set<String> filter) {
        if (filter != null) {
            Predicate<Descriptors.FieldDescriptor> p = new Predicate<Descriptors.FieldDescriptor>(){

                public boolean apply(Descriptors.FieldDescriptor descriptor) {
                    if (fields == null) {
                        return false;
                    }
                    return filter.contains(descriptor.getName());
                }
            };
            Map filtered = Maps.filterKeys((Map)fields.getAllFields(), (Predicate)p);
            return filtered.entrySet();
        }
        return fields.getAllFields().entrySet();
    }

    public static String removePrefix(String s) {
        if (s.contains("|")) {
            return StringUtils.substringAfter((String)s, (String)"|");
        }
        return s;
    }

    public static String escapeXml(String value) {
        return StringEscapeUtils.escapeXml((String)value).replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("################################################\n");
        sb.append("ID: ").append(this.id).append("\n");
        if (this.mainEntity != null) {
            sb.append("MAIN ENTITY:\n").append(this.mainEntity.getEntity().toString() + "\n");
        }
        if (this.relations != null) {
            sb.append("\nRELATIONS:\n");
            for (OafProtos.OafRel rel : this.relations.values()) {
                sb.append(rel.toString() + "\n");
            }
        }
        if (this.children != null) {
            sb.append("\nCHILDREN:\n");
            for (OafProtos.OafRel rel : this.children.values()) {
                sb.append(rel.toString() + "\n");
            }
        }
        return sb.toString();
    }
}

