package eu.dnetlib.data.mapreduce.hbase.dedup;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;

import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;

import eu.dnetlib.data.proto.RelTypeProtos.RelType;

public class DedupGrouperMapper extends TableMapper<Text, Put> {

	private static final boolean WRITE_TO_WAL = false;

	@Override
	protected void map(ImmutableBytesWritable keyIn, Result value, Context context) throws IOException, InterruptedException {

		final List<KeyValue> kvList = value.list();
		System.out.println("Grouper mapping " + kvList.size() + " rels for key: " + new String(keyIn.copyBytes()));

		for (KeyValue n : kvList) {
			for (KeyValue j : kvList) {

				byte[] nq = n.getQualifier();
				byte[] jq = j.getQualifier();

				if (!Arrays.equals(nq, jq)) {

					Put put = new Put(nq).add(Bytes.toBytes(RelType.similarRel.toString()), jq, Bytes.toBytes(""));
					put.setWriteToWAL(WRITE_TO_WAL);
					context.write(new Text(nq), put);

					context.getCounter(DedupGrouperMapper.class.getSimpleName(), "written rels").increment(1);
				}
			}
		}
	}

}
