package eu.dnetlib.data.mapreduce.hbase.dedup;

import java.io.IOException;
import java.util.Properties;

import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableOutputFormat;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;

import eu.dnetlib.data.mapreduce.JobParams;
import eu.dnetlib.data.mapreduce.hbase.AbstractHBaseMapReduceJob;
import eu.dnetlib.data.proto.TypeProtos.Type;

public class FindPersonCoauthorsJob extends AbstractHBaseMapReduceJob {

	private static final String RESULT_SCAN_PREFIX = Type.result.getNumber() + "|";

	@Override
	public Job setJobDetails(Job job, Properties p) {
		p.setProperty("mapred.reduce.tasks.speculative.execution", "true");

		initMapper(job, getScan(p), p.getProperty(JobParams.HBASE_SOURCE_TABLE));

		job.setOutputFormatClass(TableOutputFormat.class);
		job.setMapOutputKeyClass(Text.class);
		job.setMapOutputValueClass(Put.class);
		job.setNumReduceTasks(0);

		return job;
	}

	private Scan getScan(Properties p) {
		Scan scan = new Scan();
		scan.setCaching(100);
		scan.setCacheBlocks(false);
		scan.setFilter(new PrefixFilter(Bytes.toBytes(RESULT_SCAN_PREFIX)));
		return scan;
	}

	private void initMapper(final Job job, final Scan scan, final String sourceTable) {
		try {
			TableMapReduceUtil.initTableMapperJob(sourceTable, scan, FindPersonCoauthorsMapper.class, Text.class, ImmutableBytesWritable.class, job);
			//TableMapReduceUtil.initTableReducerJob(sourceTable, FindPersonCoauthorsReducer.class, job);
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
	}

}